/*
 * Decompiled with CFR 0.152.
 */
package anon.platform;

import anon.platform.AbstractOS;
import anon.util.RecursiveFileTool;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;
import java.util.StringTokenizer;
import logging.LogHolder;
import logging.LogType;

public final class LinuxOS
extends AbstractOS {
    private boolean m_bKDE = false;
    private int m_iKDEVersion = 0;
    private boolean m_bGnome = false;
    private static final String LINUX_VBOX_NETADAPTER = "vboxnet";
    public static final String[] BROWSERLIST = new String[]{"firefox", "iexplore", "explorer", "mozilla", "konqueror", "mozilla-firefox", "opera"};

    public LinuxOS() throws Exception {
        String osName = System.getProperty("os.name", "").toLowerCase();
        if (osName.toLowerCase().indexOf("linux") == -1) {
            throw new Exception("Operating system is not Linux");
        }
        Properties properties = new Properties();
        try {
            properties.load(Runtime.getRuntime().exec("env").getInputStream());
            this.m_bKDE = Boolean.valueOf(properties.getProperty("KDE_FULL_SESSION"));
            if (this.m_bKDE) {
                this.m_iKDEVersion = Integer.valueOf(properties.getProperty("KDE_SESSION_VERSION"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.m_bGnome = properties.getProperty("GNOME_DESKTOP_SESSION_ID") != null;
        this.initEnv("env");
    }

    protected boolean openLink(String a_link) {
        if (a_link == null) {
            return false;
        }
        if (this.m_bKDE) {
            return this.execute("kfmclient exec " + a_link);
        }
        if (this.m_bGnome) {
            return this.execute("gnome-open " + a_link);
        }
        return false;
    }

    public String getAppdataDefaultDirectory(String a_applicationName, boolean a_bCreate) {
        return null;
    }

    public String getConfigPath(String a_applicationName, boolean a_bCreate) {
        return System.getProperty("user.home", "") + "/.";
    }

    public boolean isVirtualBoxInterface(Object a_networkInterface) {
        String strDisplayName = AbstractOS.getInterfaceName(a_networkInterface);
        return strDisplayName != null && strDisplayName.indexOf(LINUX_VBOX_NETADAPTER) >= 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean copyAsRoot(File a_sourceFile, File a_targetDirectory, AbstractOS.AbstractRetryCopyProcess a_checkRetry) {
        String targetPath;
        boolean bUsedXterm;
        block16: {
            String sourcePath;
            String execCmd;
            block15: {
                if (a_sourceFile == null || a_targetDirectory == null || !a_targetDirectory.isDirectory()) {
                    return false;
                }
                String KDEPath = "";
                String s = null;
                String[] command = new String[3];
                execCmd = null;
                bUsedXterm = false;
                sourcePath = a_sourceFile.getPath();
                targetPath = a_targetDirectory.getPath() + "/";
                a_checkRetry.incrementProgress();
                if (!this.m_bKDE) break block15;
                if (this.m_iKDEVersion == 4) {
                    try {
                        command[0] = "kde4-config";
                        command[1] = "--path";
                        command[2] = "exe";
                        Process pr = Runtime.getRuntime().exec(command);
                        BufferedReader stdInput = new BufferedReader(new InputStreamReader(pr.getInputStream()));
                        while (!this.procDone(pr)) {
                            while ((s = stdInput.readLine()) != null) {
                                KDEPath = KDEPath + s;
                            }
                        }
                        LogHolder.log(5, LogType.MISC, "The KDE-Path on your system is: " + KDEPath);
                        StringTokenizer tokenizerKDEPath = new StringTokenizer(KDEPath, ":");
                        while (tokenizerKDEPath.hasMoreTokens()) {
                            String tokenCurrent = tokenizerKDEPath.nextToken();
                            File kdesuExec = new File(tokenCurrent + "kdesu");
                            if (!kdesuExec.isFile()) continue;
                            execCmd = tokenCurrent + "kdesu";
                            break;
                        }
                    }
                    catch (IOException e) {
                        LogHolder.log(2, LogType.MISC, e);
                    }
                    if (execCmd == null) {
                        LogHolder.log(1, LogType.MISC, "No path to kdesu found, aborting...");
                        return false;
                    }
                    execCmd = execCmd + " 'cp -r " + sourcePath + " " + targetPath + "'";
                    this.executeShell(execCmd);
                    break block16;
                } else {
                    execCmd = "kdesu 'cp -r " + sourcePath + " " + targetPath + "'";
                    this.executeShell(execCmd);
                }
                break block16;
            }
            if (this.m_bGnome) {
                execCmd = "gksu 'cp -r " + sourcePath + " " + targetPath + "'";
                this.executeShell(execCmd);
            } else {
                execCmd = "xterm -e su -c 'cp -r " + sourcePath + " " + targetPath + "'";
                this.executeShell(execCmd);
                bUsedXterm = true;
            }
        }
        File target = new File(targetPath + a_sourceFile.getName());
        if (RecursiveFileTool.equals(target, a_sourceFile, true)) {
            while (a_checkRetry.incrementProgress()) {
            }
            return true;
        }
        if (bUsedXterm && a_checkRetry != null && a_checkRetry.checkRetry()) {
            a_checkRetry.reset();
            return this.copyAsRoot(a_sourceFile, a_targetDirectory, a_checkRetry);
        }
        return false;
    }

    private void executeShell(String a_cmd) {
        try {
            String[] command = new String[]{"sh", "-c", a_cmd};
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(command);
            pr.waitFor();
        }
        catch (Exception e) {
            LogHolder.log(2, LogType.MISC, e);
        }
    }

    private boolean procDone(Process a_process) {
        try {
            int v = a_process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }
}

