/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.crypto.MyAES;
import anon.crypto.MyRSA;
import anon.crypto.MyRSAPublicKey;
import anon.crypto.tinytls.util.hash;
import anon.tor.cells.Cell;
import anon.tor.cells.CreateCell;
import anon.tor.cells.RelayCell;
import anon.tor.ordescription.ORDescriptor;
import anon.util.ByteArrayUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.SecureRandom;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.agreement.DHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.generators.DHKeyPairGenerator;
import org.bouncycastle.crypto.params.DHKeyGenerationParameters;
import org.bouncycastle.crypto.params.DHParameters;
import org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.bouncycastle.crypto.params.DHPublicKeyParameters;

public class OnionRouter {
    private static final BigInteger SAFEPRIME = new BigInteger("00FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger MINKEY = new BigInteger(new byte[]{1, 0, 0, 0});
    private static final BigInteger MAXKEY = SAFEPRIME.subtract(MINKEY);
    private static final DHParameters DH_PARAMS = new DHParameters(SAFEPRIME, new BigInteger("2"));
    private ORDescriptor m_description;
    private DHBasicAgreement m_dhe;
    private MyAES m_encryptionEngine;
    private MyAES m_decryptionEngine;
    private OnionRouter m_nextOR;
    private int m_circID;
    private SHA1Digest m_digestDf;
    private SHA1Digest m_digestDb;
    private boolean m_extended;

    public OnionRouter(int circID, ORDescriptor description) throws IOException {
        this.m_description = description;
        this.m_circID = circID;
        this.m_nextOR = null;
        this.m_extended = false;
    }

    public ORDescriptor getDescription() {
        return this.m_description;
    }

    public synchronized RelayCell encryptCell(RelayCell cell) throws Exception {
        if (this.m_nextOR != null) {
            cell = this.m_nextOR.encryptCell(cell);
        } else {
            cell.generateDigest(this.m_digestDf);
        }
        cell.doCryptography(this.m_encryptionEngine);
        return cell;
    }

    public synchronized RelayCell decryptCell(RelayCell cell) throws Exception {
        RelayCell c = cell;
        c.doCryptography(this.m_decryptionEngine);
        if (this.m_nextOR != null && this.m_extended) {
            c = this.m_nextOR.decryptCell(c);
        } else {
            c.checkDigest(this.m_digestDb);
        }
        return c;
    }

    public CreateCell createConnection() throws Exception {
        CreateCell cell = new CreateCell(this.m_circID);
        cell.setPayload(this.createExtendOnionSkin(), 0);
        return cell;
    }

    public boolean checkCreatedCell(Cell cell) {
        try {
            this.checkExtendParameters(cell.getPayload(), 0, 148);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    private RelayCell extendConnection(String address, int port) throws IOException, InvalidCipherTextException, Exception {
        byte[] payload = ByteArrayUtil.conc(InetAddress.getByName(address).getAddress(), ByteArrayUtil.inttobyte(port, 2), this.createExtendOnionSkin());
        MyRSAPublicKey key = this.m_description.getSigningKey();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DEROutputStream dout = new DEROutputStream(out);
        dout.writeObject(key.getAsSubjectPublicKeyInfo().getPublicKey());
        dout.flush();
        byte[] b = out.toByteArray();
        byte[] hash1 = hash.sha(b);
        payload = ByteArrayUtil.conc(payload, hash1);
        RelayCell cell = new RelayCell(this.m_circID, 6, 0, payload);
        return cell;
    }

    public RelayCell extendConnection(ORDescriptor description) throws IOException, InvalidCipherTextException, Exception {
        RelayCell cell;
        if (this.m_nextOR == null) {
            this.m_nextOR = new OnionRouter(this.m_circID, description);
            cell = this.m_nextOR.extendConnection(description.getAddress(), description.getPort());
            cell.generateDigest(this.m_digestDf);
        } else {
            cell = this.m_nextOR.extendConnection(description);
        }
        cell.doCryptography(this.m_encryptionEngine);
        return cell;
    }

    public boolean checkExtendedCell(RelayCell cell) {
        try {
            if (this.m_nextOR == null) {
                this.checkExtendParameters(cell.getPayload(), 11, 148);
                LogHolder.log(7, LogType.MISC, "[TOR] Circuit '" + this.m_circID + "' Extended");
                return true;
            }
            cell.doCryptography(this.m_decryptionEngine);
            if (!this.m_extended) {
                cell.checkDigest(this.m_digestDb);
                this.m_extended = this.m_nextOR.checkExtendedCell(cell);
                if (!this.m_extended) {
                    this.m_nextOR = null;
                }
                return this.m_extended;
            }
            return this.m_nextOR.checkExtendedCell(cell);
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte[] createExtendOnionSkin() throws IOException, InvalidCipherTextException, Exception {
        byte[] rsaBlock = new byte[86];
        byte[] key = new byte[16];
        MyAES aes = new MyAES();
        SecureRandom random = new SecureRandom();
        random.nextBytes(key);
        aes.init(true, key);
        DHKeyGenerationParameters params = new DHKeyGenerationParameters(new SecureRandom(), DH_PARAMS);
        DHKeyPairGenerator kpGen = new DHKeyPairGenerator();
        kpGen.init(params);
        AsymmetricCipherKeyPair pair = kpGen.generateKeyPair();
        DHPublicKeyParameters dhpub = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters dhpriv = (DHPrivateKeyParameters)pair.getPrivate();
        this.m_dhe = new DHBasicAgreement();
        this.m_dhe.init(dhpriv);
        byte[] dhpubY = dhpub.getY().toByteArray();
        int dhpubOffset = 0;
        if (dhpubY[0] == 0) {
            dhpubOffset = 1;
        }
        System.arraycopy(key, 0, rsaBlock, 0, 16);
        System.arraycopy(dhpubY, dhpubOffset, rsaBlock, 16, 70);
        MyRSA rsa = new MyRSA();
        rsa.init(this.m_description.getOnionKey());
        rsaBlock = rsa.processBlockOAEP(rsaBlock, 0, rsaBlock.length);
        byte[] result = new byte[186];
        System.arraycopy(rsaBlock, 0, result, 0, 128);
        aes.processBytesCTR(dhpubY, 70 + dhpubOffset, result, 128, 58);
        return result;
    }

    private void checkExtendParameters(byte[] param, int offset, int len) throws Exception {
        byte[] a = new byte[128];
        System.arraycopy(param, offset, a, 0, 128);
        DHPublicKeyParameters dhserverpub = new DHPublicKeyParameters(new BigInteger(1, a), DH_PARAMS);
        BigInteger key = this.m_dhe.calculateAgreement(dhserverpub);
        byte[] agreement = key.toByteArray();
        byte[] buff = new byte[129];
        if (agreement[0] == 0) {
            System.arraycopy(agreement, 1, buff, 0, 128);
        } else {
            System.arraycopy(agreement, 0, buff, 0, 128);
        }
        byte[] kh = hash.sha(buff);
        for (int i = 0; i < kh.length; ++i) {
            if (kh[i] == param[i + offset + 128]) continue;
            throw new Exception("wrong derivative key");
        }
        if (key.compareTo(MINKEY) == -1 || key.compareTo(MAXKEY) == 1) {
            throw new CryptoException("Calculated DH-Key is not in allowed range (KEY:" + key.doubleValue() + ")");
        }
        if (key.bitCount() < 16 || 1024 - key.bitCount() < 16) {
            throw new CryptoException("Calculated DH-Key is not valid. Not enough zeros ore ones");
        }
        buff[128] = 1;
        this.m_digestDf = new SHA1Digest();
        byte[] keydata = hash.sha(buff);
        this.m_digestDf.update(keydata, 0, 20);
        buff[128] = 2;
        this.m_digestDb = new SHA1Digest();
        keydata = hash.sha(buff);
        this.m_digestDb.update(keydata, 0, 20);
        buff[128] = 3;
        keydata = hash.sha(buff);
        this.m_encryptionEngine = new MyAES();
        this.m_encryptionEngine.init(true, keydata, 0, 16);
        byte[] keyKb = new byte[16];
        System.arraycopy(keydata, 16, keyKb, 0, 4);
        buff[128] = 4;
        keydata = hash.sha(buff);
        System.arraycopy(keydata, 0, keyKb, 4, 12);
        this.m_decryptionEngine = new MyAES();
        this.m_decryptionEngine.init(true, keyKb);
    }
}

