/*
 * Decompiled with CFR 0.152.
 */
package anon.util.captcha;

import anon.util.captcha.MyImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class BinaryImageExtractor {
    public static MyImage binaryToImage(byte[] a_binaryData) {
        MyImage resultImage = null;
        try {
            ByteArrayInputStream binaryData = new ByteArrayInputStream(a_binaryData);
            DataInputStream transformer = new DataInputStream(binaryData);
            int width = transformer.readInt();
            int height = transformer.readInt();
            if (width < 0 || height < 0 || a_binaryData.length != 8 + (height * width + 7) / 8) {
                throw new Exception("BinaryImageExtractor: binaryToImage: The binary image has an invalid size.");
            }
            int[] pixels = new int[width * height];
            int currentByte = binaryData.read();
            for (int i = 0; i < width * height; ++i) {
                pixels[i] = (currentByte & 0x80) == 128 ? -12566464 : -1;
                currentByte <<= 1;
                if (i % 8 != 7) continue;
                currentByte = binaryData.read();
            }
            resultImage = new MyImage(pixels, width, height);
        }
        catch (Exception e) {
            resultImage = null;
        }
        return resultImage;
    }
}

