/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast;

import infoservice.agreement.common.TimeoutThread;
import infoservice.agreement.logging.GiveThingsAName;
import infoservice.agreement.logging.IAgreementLog;
import infoservice.agreement.multicast.ConsensusLogEchoMulticast;
import infoservice.agreement.multicast.interfaces.IAgreementHandler;
import infoservice.agreement.multicast.interfaces.IAgreementMessage;
import infoservice.agreement.multicast.interfaces.IConsensusLog;
import infoservice.agreement.multicast.interfaces.IInfoService;
import infoservice.agreement.multicast.messages.AMessage;
import infoservice.agreement.multicast.messages.CommitMessage;
import infoservice.agreement.multicast.messages.CommitmentMessage;
import infoservice.agreement.multicast.messages.ConfirmationMessage;
import infoservice.agreement.multicast.messages.EchoMessage;
import infoservice.agreement.multicast.messages.InitMessage;
import infoservice.agreement.multicast.messages.RejectMessage;
import infoservice.dynamic.DynamicConfiguration;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class EchoMulticastAgreementHandlerImpl
implements IAgreementHandler {
    private Hashtable m_currentAgreementResults = new Hashtable();
    private Hashtable m_phaseOneAgreemetResults = new Hashtable();
    private IInfoService m_infoService;
    private IAgreementLog m_logger;
    private String m_lastCommonRandom;
    private Hashtable m_logHashTable = new Hashtable();
    private TimeoutThread m_agreementTimeOutThread = null;
    private CommitmentMessage m_commitmentMessage = null;
    protected String m_currentMessage = "";
    private boolean m_agreementTimeoutThreadIsStarted = false;
    private int m_currentPhase = 0;

    public EchoMulticastAgreementHandlerImpl(IInfoService a_infoService) {
        this.m_infoService = a_infoService;
        this.m_lastCommonRandom = "0000000000";
    }

    @Override
    public void handleMessage(IAgreementMessage a_msg) throws IllegalArgumentException {
        if (a_msg == null) {
            return;
        }
        switch (a_msg.getMessageType()) {
            case 0: {
                this.handleInitMessage((InitMessage)a_msg);
                break;
            }
            case 1: {
                this.handleEchoMessage((EchoMessage)a_msg);
                break;
            }
            case 2: {
                this.handleCommitMessage((CommitMessage)a_msg);
                break;
            }
            case 3: {
                this.handleRejectMessage((RejectMessage)a_msg);
                break;
            }
            case 4: {
                this.handleConfirmationMessage((ConfirmationMessage)a_msg);
                break;
            }
            default: {
                this.debug(" ----- DISCARD INCOMMING MESSAGE CAUSE AGREEMENT IS OVER " + a_msg);
            }
        }
    }

    private void handleConfirmationMessage(ConfirmationMessage a_message) {
        ConsensusLogEchoMulticast consensus = this.getConsensusLog(a_message);
        if (consensus.isAgreed()) {
            return;
        }
        a_message.changeIntoCommitMessage();
        this.handleCommitMessage(a_message);
    }

    private void handleRejectMessage(RejectMessage a_message) {
        ConsensusLogEchoMulticast consensus = this.getConsensusLog(a_message);
        consensus.addRejectMessage(a_message);
        this.debug("A: handleRejectMessage: rejected=" + consensus.isRejected() + " restarted=" + consensus.isRestarted());
        if (consensus.isRejected() && consensus.getLastCommonRandom() == null) {
            this.notifyBabylonianConfusion();
            return;
        }
        if (consensus.isRejected() && !consensus.isRestarted()) {
            consensus.setRestarted(true);
            consensus.stopTimeout();
            this.m_lastCommonRandom = consensus.getLastCommonRandom();
            InitMessage msg = new InitMessage(this.m_infoService.getIdentifier(), this.m_currentMessage, this.m_lastCommonRandom);
            this.debug(" ----> I GOT A NEW CHANCE TO SEND InitMessage TO ALL " + msg);
            this.debug(" ----> SEND INIT-Message TO ALL " + msg);
            this.handleInitMessage(msg);
            this.m_infoService.multicastMessage(msg);
        }
    }

    private void handleInitMessage(InitMessage a_message) {
        if (this.m_agreementTimeOutThread == null && !this.m_agreementTimeoutThreadIsStarted) {
            this.m_agreementTimeoutThreadIsStarted = true;
            this.m_agreementTimeOutThread = new TimeoutThread(this, DynamicConfiguration.getInstance().getEmcGlobalTimeout());
            this.m_agreementTimeOutThread.start();
        }
        if (!a_message.getLastCommonRandom().equals(this.m_lastCommonRandom)) {
            RejectMessage msg = new RejectMessage(a_message, this.m_infoService.getIdentifier(), this.m_lastCommonRandom);
            this.m_infoService.sendMessageTo(a_message.getInitiatorsId(), msg);
            String initName = GiveThingsAName.getNameForNumber(a_message.getInitiatorsId());
            this.debug(" ----> REJECT  InitMessage FROM " + initName + " (" + a_message.getLastCommonRandom() + "!=" + this.m_lastCommonRandom + ") " + a_message);
            return;
        }
        ConsensusLogEchoMulticast consensus = this.getConsensusLog(a_message);
        if (!consensus.addInitMessage(a_message)) {
            return;
        }
        EchoMessage echoMessage = null;
        echoMessage = new EchoMessage(a_message, this.getInfoService().getIdentifier());
        if (a_message.getInitiatorsId().equals(this.getInfoService().getIdentifier())) {
            this.handleEchoMessage(echoMessage);
        }
        this.m_infoService.sendMessageTo(echoMessage.getInitiatorsId(), echoMessage);
        String initName = GiveThingsAName.getNameForNumber(echoMessage.getInitiatorsId());
        this.debug(" ----> SEND EchoMessage TO " + initName + " " + a_message);
    }

    private void handleEchoMessage(EchoMessage a_message) {
        if (!a_message.getInitiatorsId().equals(this.getInfoService().getIdentifier())) {
            this.debug(" ----> IGNORE EchoMessage (I'm not the sender.)");
            return;
        }
        ConsensusLogEchoMulticast consensus = this.getConsensusLog(a_message);
        if (consensus.isAgreed()) {
            return;
        }
        if (!consensus.addEchoMessage(a_message)) {
            return;
        }
        CommitMessage commit = consensus.tryToCreateACommitMessage();
        if (commit == null) {
            return;
        }
        this.debug(" ----> SEND CommitMessage TO ALL  " + commit);
        this.handleCommitMessage(commit);
        this.m_infoService.multicastMessage(commit);
    }

    private void handleCommitMessage(CommitMessage a_message) {
        ConsensusLogEchoMulticast consensus = this.getConsensusLog(a_message);
        if (consensus.isAgreed() || consensus.isComitted()) {
            return;
        }
        if (!consensus.addCommitMessage(a_message)) {
            return;
        }
        this.m_currentAgreementResults.put(a_message.getInitiatorsId(), a_message.getProposal());
        this.debug(" ----> AGREEMENT REACHED " + this.m_currentAgreementResults.size() + " -> " + this.getInfoService().getNumberOfAllInfoservices() + " " + a_message);
        if (a_message.getInitiatorsId().equals(this.m_infoService.getIdentifier())) {
            consensus.setComitted(true);
        }
        if (!consensus.isComitted()) {
            ConfirmationMessage msg = new ConfirmationMessage(a_message, this.m_infoService.getIdentifier());
            this.debug(" ----> SEND ConfirmationMessage TO ALL  " + msg);
            consensus.setComitted(true);
            this.getInfoService().multicastMessage(msg);
        }
        int count = 0;
        Enumeration en = this.m_logHashTable.elements();
        while (en.hasMoreElements()) {
            ConsensusLogEchoMulticast l = (ConsensusLogEchoMulticast)en.nextElement();
            if (!l.isComitted()) continue;
            ++count;
        }
        this.info("GOT COMMIT FOR " + GiveThingsAName.getNameForNumber(a_message.getInitiatorsId()) + ": HAVE NOW " + count + " COMMITS, NEED AT LEAST " + (2 * this.m_infoService.getNumberOfAllInfoservices() + 1) / 3);
    }

    @Override
    public void startAgreementCommitmentProtocol() {
        if (this.m_agreementTimeoutThreadIsStarted) {
            return;
        }
        this.m_commitmentMessage = new CommitmentMessage();
        this.m_currentMessage = this.m_commitmentMessage.getHashValueAndRandomOne();
        this.m_currentPhase = 1;
        this.sendReliableBroadcastMessage(this.m_currentMessage);
    }

    protected void sendReliableBroadcastMessage(String a_message) {
        InitMessage msg = new InitMessage(this.m_infoService.getIdentifier(), a_message, this.m_lastCommonRandom);
        this.getConsensusLog(msg);
        this.debug(" ----> SEND initmessage TO ALL " + msg);
        this.handleInitMessage(msg);
        this.m_infoService.multicastMessage(msg);
    }

    @Override
    public void reset() {
        this.m_agreementTimeOutThread = null;
        this.m_agreementTimeoutThreadIsStarted = false;
        this.m_currentAgreementResults = new Hashtable();
        this.m_phaseOneAgreemetResults = new Hashtable();
        this.m_currentPhase = 0;
        this.m_logHashTable = new Hashtable();
        this.m_currentMessage = "";
    }

    public void softReset() {
        this.m_agreementTimeOutThread = null;
        this.m_agreementTimeoutThreadIsStarted = false;
        this.m_currentAgreementResults = new Hashtable();
        if (this.m_currentPhase != 1) {
            this.m_phaseOneAgreemetResults = new Hashtable();
        }
        this.m_logHashTable = new Hashtable();
        this.m_currentMessage = "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ConsensusLogEchoMulticast getConsensusLog(AMessage a_msg) {
        Hashtable hashtable = this.m_logHashTable;
        synchronized (hashtable) {
            ConsensusLogEchoMulticast consensusLog = (ConsensusLogEchoMulticast)this.m_logHashTable.get(a_msg.getConsensusId());
            if (consensusLog == null) {
                consensusLog = new ConsensusLogEchoMulticast(this, a_msg.getConsensusId(), this.m_logger, a_msg.getInitiatorsId());
                this.m_logHashTable.put(a_msg.getConsensusId(), consensusLog);
            }
            return consensusLog;
        }
    }

    @Override
    public void notifyConsensusLogTimeout(IConsensusLog consensus) {
        String name = GiveThingsAName.getNameForNumber(consensus.getInitiatorId());
        this.info(" ----- CONSENSUSLOG TIMOUT FOR " + name);
    }

    private void notifyBabylonianConfusion() {
        this.info(" --- BABYLONIAN CONFUSION!! ---");
    }

    private Long checkTheResults() {
        Hashtable<Object, String> results = new Hashtable<Object, String>();
        Object key = null;
        String value1 = null;
        String value2 = null;
        CommitmentMessage cmMessage = null;
        String hash2 = "";
        String randNumber = "";
        Enumeration en = this.m_phaseOneAgreemetResults.keys();
        while (en.hasMoreElements()) {
            key = en.nextElement();
            if (!this.m_currentAgreementResults.containsKey(key)) continue;
            value1 = (String)this.m_phaseOneAgreemetResults.get(key);
            value2 = (String)this.m_currentAgreementResults.get(key);
            if (value1 == null || value2 == null) {
                this.debug("SKIPPING null VALUE");
                continue;
            }
            try {
                cmMessage = new CommitmentMessage(value2);
                randNumber = CommitmentMessage.extractRandomOneFromHashAndRandomOneConcatenation(value1);
                hash2 = CommitmentMessage.extractHashFromHashAndRandomOneConcatenation(value1);
            }
            catch (Exception e) {
                continue;
            }
            if (!randNumber.equals(cmMessage.getRandomOne())) {
                this.debug("check the randomOne number failed" + randNumber + " -> " + cmMessage.getRandomOne());
                continue;
            }
            if (!hash2.equals(cmMessage.getHashCode())) {
                this.debug("check hash values failed" + hash2 + "-> " + cmMessage.getHashCode());
                continue;
            }
            String nameFOrKey = GiveThingsAName.getNameForNumber(key.toString());
            this.debug("AGREEMENT FOR: " + nameFOrKey + ": " + cmMessage.getProposal());
            results.put(key, cmMessage.getProposal());
        }
        int cm = (this.getInfoService().getNumberOfAllInfoservices() * 2 + 1) / 3;
        if (results.size() < cm) {
            this.debug("ATTENTION! AGREEMENT FINISHED WITHOUT A  RESULT. CRITICAL MASS: " + cm + " REACHED RESULTS: " + results.size());
            return null;
        }
        long comRand = 0L;
        Enumeration emu = results.elements();
        while (emu.hasMoreElements()) {
            comRand += Long.parseLong((String)emu.nextElement());
        }
        return new Long(comRand);
    }

    public String getLastCommonRandom() {
        return this.m_lastCommonRandom;
    }

    @Override
    public void setLastCommonRandom(String commonRandom) {
        this.m_lastCommonRandom = commonRandom;
    }

    private void debug(String a_message) {
        this.m_logger.debug(a_message);
    }

    void info(String a_message) {
        this.m_logger.info(a_message);
    }

    @Override
    public IInfoService getInfoService() {
        return this.m_infoService;
    }

    @Override
    public void timeout(Object a_value) {
        this.debug(" AGREEMENT TIMED OUT");
        this.info(" AGREEMENT TIMED OUT: " + new Date().toString());
        if (this.m_agreementTimeOutThread != null) {
            this.m_agreementTimeOutThread.cancel();
        }
        switch (this.m_currentPhase) {
            case 1: {
                this.m_phaseOneAgreemetResults = this.m_currentAgreementResults;
                this.softReset();
                this.m_currentMessage = this.m_commitmentMessage.getConcatenation();
                this.m_currentPhase = 2;
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(DynamicConfiguration.getInstance().getAgreementPhaseGap());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        EchoMulticastAgreementHandlerImpl.this.info("Start reveal phase...");
                        EchoMulticastAgreementHandlerImpl.this.sendReliableBroadcastMessage(EchoMulticastAgreementHandlerImpl.this.m_currentMessage);
                    }
                }.start();
                break;
            }
            case 2: {
                Long oldCmmonRandom = new Long(Long.parseLong(this.m_lastCommonRandom));
                Long newCommonRandom = this.checkTheResults();
                if (newCommonRandom != null) {
                    this.m_lastCommonRandom = newCommonRandom.toString();
                }
                this.m_currentPhase = 0;
                this.m_infoService.notifyAgreement(oldCmmonRandom, newCommonRandom);
                break;
            }
        }
    }

    @Override
    public void setLog(IAgreementLog a_log) {
        this.m_logger = a_log;
    }
}

