/*
 * Decompiled with CFR 0.152.
 */
package infoservice.dynamic;

import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import infoservice.dynamic.DynamicConfiguration;
import infoservice.dynamic.VirtualCascade;
import java.util.Enumeration;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class DynamicCascadeConfigurator {
    public void buildCascades(long a_seed) {
        LogHolder.log(7, LogType.ALL, "Starting dynamic cascade configuration");
        Enumeration enumMixes = Database.getInstance(MixInfo.class).getEntrySnapshotAsEnumeration();
        Vector<MixInfo> firstMixes = new Vector<MixInfo>();
        Vector<MixInfo> middleMixes = new Vector<MixInfo>();
        Vector<MixInfo> lastMixes = new Vector<MixInfo>();
        while (enumMixes.hasMoreElements()) {
            MixInfo mi = (MixInfo)enumMixes.nextElement();
            if (!this.isUsable(mi)) continue;
            switch (mi.getType()) {
                case 0: {
                    firstMixes.add(mi);
                    break;
                }
                case 1: {
                    middleMixes.add(mi);
                    break;
                }
                case 2: {
                    lastMixes.add(mi);
                }
            }
        }
        LogHolder.log(7, LogType.ALL, "FirstMixes: " + firstMixes.size() + ", MiddleMixes: " + middleMixes.size() + ", LastMixes: " + lastMixes.size());
        if (firstMixes.size() == 0 && middleMixes.size() == 0 || lastMixes.size() == 0) {
            LogHolder.log(6, LogType.ALL, "Not enough mixes to build new cascades, exiting");
            return;
        }
        Database.getInstance(VirtualCascade.class).removeAll();
        Vector newDynamicCascades = null;
        try {
            newDynamicCascades = DynamicConfiguration.getInstance().getCascadeBuildingStrategy().createCascades(firstMixes, middleMixes, lastMixes, a_seed);
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.ALL, "Error while building new cascades: " + e.toString());
            return;
        }
        Enumeration enumCascades = newDynamicCascades.elements();
        while (enumCascades.hasMoreElements()) {
            MixCascade cascade = (MixCascade)enumCascades.nextElement();
            VirtualCascade tmp = new VirtualCascade(cascade);
            Enumeration enMixes = cascade.getMixIds().elements();
            boolean addTemporaryCascade = true;
            while (enMixes.hasMoreElements()) {
                String mixId = enMixes.nextElement().toString();
                MixCascade oldCascade = this.getCurrentCascade(mixId);
                if (oldCascade == null) continue;
                if (!cascade.getMixIDsAsString().equals(oldCascade.getMixIDsAsString())) {
                    Database.getInstance(MixCascade.class).remove(oldCascade);
                    continue;
                }
                addTemporaryCascade = false;
                break;
            }
            if (!addTemporaryCascade) continue;
            Database.getInstance(VirtualCascade.class).update(tmp);
        }
        LogHolder.log(6, LogType.ALL, "Cascades  are ready!");
    }

    private MixCascade getCurrentCascade(String a_mixId) {
        Enumeration knownMixCascades = Database.getInstance(MixCascade.class).getEntryList().elements();
        MixCascade assignedCascade = null;
        while (knownMixCascades.hasMoreElements() && assignedCascade == null) {
            MixCascade currentCascade = (MixCascade)knownMixCascades.nextElement();
            if (!currentCascade.getMixIds().contains(a_mixId)) continue;
            assignedCascade = currentCascade;
            break;
        }
        return assignedCascade;
    }

    private boolean isUsable(MixInfo a_mixInfo) {
        if (!a_mixInfo.isDynamic()) {
            return false;
        }
        MixCascade assignedCascade = this.getCurrentCascade(a_mixInfo.getId());
        if (assignedCascade != null) {
            Enumeration enumMixes = assignedCascade.getMixIds().elements();
            while (enumMixes.hasMoreElements()) {
                String id = (String)enumMixes.nextElement();
                MixInfo mixInfo = (MixInfo)Database.getInstance(MixInfo.class).getEntryById(id);
                if (mixInfo == null || mixInfo.isDynamic()) continue;
                return false;
            }
        }
        return true;
    }
}

