/*
 * Decompiled with CFR 0.152.
 */
package infoservice.dynamic;

import anon.crypto.SignatureVerifier;
import anon.infoservice.Database;
import anon.infoservice.HttpResponseStructure;
import anon.infoservice.MixCascade;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import infoservice.dynamic.VirtualCascade;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Random;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DynamicNetworkingHelper {
    public HttpResponseStructure lastMixPostDynaCascade(byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(200);
        try {
            LogHolder.log(7, LogType.NET, "LastMixPostDynaCascade: MixCascade HELO received: XML: " + new String(a_postData));
            Element mixCascadeNode = (Element)XMLUtil.getFirstChildByName(XMLUtil.toXMLDocument(a_postData), "MixCascade");
            if (SignatureVerifier.getInstance().verifyXml(mixCascadeNode, 1)) {
                MixCascade mixCascadeEntry = new MixCascade(mixCascadeNode);
                VirtualCascade tmp = new VirtualCascade(mixCascadeEntry);
                Database.getInstance(VirtualCascade.class).update(tmp);
            } else {
                LogHolder.log(4, LogType.NET, "Signature check failed for MixCascade entry! XML: " + new String(a_postData));
                httpResponse = new HttpResponseStructure(500);
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            httpResponse = new HttpResponseStructure(400);
        }
        return httpResponse;
    }

    public HttpResponseStructure mixPostConnectivityTest(InetAddress a_sourceAddress, byte[] a_postData) {
        HttpResponseStructure httpResponse = new HttpResponseStructure(500);
        int port = this.extractPort(a_postData);
        if (port == -1) {
            LogHolder.log(7, LogType.MISC, "connectivityTest: No Port given");
            return httpResponse;
        }
        Document docConnectivity = null;
        docConnectivity = this.isReachable(a_sourceAddress, port) ? this.constructAnswer("OK") : this.constructAnswer("Failed");
        httpResponse = new HttpResponseStructure(2, 0, XMLUtil.toString(docConnectivity));
        return httpResponse;
    }

    private Document constructAnswer(String a_response) {
        Document result = XMLUtil.createDocument();
        Element nodeConnectivity = result.createElement("Connectivity");
        Element nodeResult = result.createElement("Result");
        result.appendChild(nodeConnectivity);
        nodeConnectivity.appendChild(nodeResult);
        XMLUtil.setValue((Node)nodeResult, a_response);
        return result;
    }

    private boolean isReachable(InetAddress a_Address, int a_port) {
        Random rand = new Random();
        long echoRequest = Math.abs(rand.nextLong());
        String result = this.doPing(a_Address, a_port, echoRequest);
        if (result == null) {
            return false;
        }
        long echoResponse = Long.parseLong(result);
        return echoResponse == echoRequest;
    }

    private String doPing(InetAddress a_Address, int a_port, long a_echoRequest) {
        StringBuffer result = new StringBuffer();
        try {
            Socket socket = new Socket(a_Address, a_port);
            BufferedOutputStream str = new BufferedOutputStream(socket.getOutputStream());
            BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
            byte[] content = Long.toString(a_echoRequest).getBytes();
            str.write(content);
            str.flush();
            byte[] buff = new byte[content.length];
            int bytes = -1;
            while ((bytes = in.read(buff)) != -1) {
                byte[] real = new byte[bytes];
                System.arraycopy(buff, 0, real, 0, bytes);
                result.append(new String(real));
            }
            in.close();
            socket.close();
        }
        catch (Exception e) {
            return null;
        }
        LogHolder.log(7, LogType.NET, "Answer from Mix was:  " + result);
        return result.toString();
    }

    private int extractPort(byte[] a_postData) {
        int port = -1;
        try {
            Document doc = XMLUtil.toXMLDocument(a_postData);
            Node rootNode = doc.getFirstChild();
            Element portNode = (Element)XMLUtil.getFirstChildByName(rootNode, "Port");
            port = XMLUtil.parseValue((Node)portNode, -1);
        }
        catch (XMLParseException xMLParseException) {
            // empty catch block
        }
        return port;
    }
}

