/*
 * Decompiled with CFR 0.152.
 */
package anon.anonudp.mixpacket;

import anon.anonudp.exception.DecryptionFailed;
import anon.anonudp.exception.PacketCreationFailed;
import anon.anonudp.exception.SymmetricKeyCreationFailed;
import anon.anonudp.mixmessage.Fragment;
import anon.anonudp.mixmessage.Util;
import anon.anonudp.mixmessage.crypto.CTRCipher;
import anon.anonudp.mixmessage.crypto.Counter;
import anon.anonudp.mixmessage.crypto.MyCTRCipher;
import anon.anonudp.mixmessage.crypto.PrivateKey;
import anon.anonudp.mixmessage.crypto.PublicKey;
import anon.anonudp.mixpacket.DataPacket;
import anon.anonudp.mixpacket.InitPacket;
import anon.anonudp.mixpacket.ProcessedDataPacket;
import anon.anonudp.mixpacket.ProcessedInitPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import org.bouncycastle.crypto.InvalidCipherTextException;

public class PacketFactory {
    private int channelID;
    private byte[] initPayload;
    private PublicKey[] publicKeys;
    private byte[][] requestChannelKeys;
    private byte[][] responseChannelKeys;
    private MyCTRCipher[] m_arcipherDecrypt;
    private int mixCount;
    private Counter requestCounter;

    public PacketFactory(int channelID, byte[] initPayload, PublicKey[] publicKeys) {
        this.requestChannelKeys = new byte[publicKeys.length][16];
        this.responseChannelKeys = new byte[publicKeys.length][16];
        this.m_arcipherDecrypt = new MyCTRCipher[publicKeys.length];
        for (int i = 0; i < publicKeys.length; ++i) {
            this.m_arcipherDecrypt[i] = MyCTRCipher.getCipher(this.responseChannelKeys[i], false);
        }
        this.channelID = channelID;
        this.initPayload = initPayload;
        if (publicKeys.length < 1) {
            throw new IllegalArgumentException("Was given empty public key list.");
        }
        this.publicKeys = publicKeys;
        this.mixCount = this.publicKeys.length;
        this.requestCounter = new Counter();
        this.requestCounter.count();
    }

    public PacketFactory(byte[][] symKeys) {
        this.m_arcipherDecrypt = new MyCTRCipher[symKeys.length];
        this.responseChannelKeys = new byte[symKeys.length][16];
        for (int i = 0; i < symKeys.length; ++i) {
            this.m_arcipherDecrypt[i] = MyCTRCipher.getCipher(symKeys[i], false);
            this.responseChannelKeys[i] = symKeys[i];
        }
        this.requestChannelKeys = null;
    }

    ProcessedInitPacket process(InitPacket packet, PrivateKey privateKey) throws SymmetricKeyCreationFailed, DecryptionFailed {
        PublicKey disposableKey = packet.getPublicKey().blind(privateKey).blind(packet.getMessageID());
        byte[] symmetricDisposableKey = disposableKey.toSymmetricKey();
        CTRCipher cipher = CTRCipher.getCipher(symmetricDisposableKey, new Counter(packet.getMessageID()).asIV(), false);
        try {
            boolean decryptionFailed;
            byte[] decryptedChannelOnion = cipher.decryptBuffer(packet.getChannelKeyOnion());
            byte[] requestChannelKey = new byte[16];
            byte[] responseChannelKey = new byte[16];
            byte[] encryptedChannelOnion = new byte[64];
            ByteArrayInputStream bis = new ByteArrayInputStream(decryptedChannelOnion);
            boolean bl = decryptionFailed = bis.read(requestChannelKey) != requestChannelKey.length || bis.read(responseChannelKey) != responseChannelKey.length || bis.read(encryptedChannelOnion) != encryptedChannelOnion.length;
            if (decryptionFailed) {
                throw new DecryptionFailed("The channel key onion of the packet was not big enough to extract all parts.");
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(encryptedChannelOnion);
            bos.write(Util.randomBytes(32));
            byte[] processedChannelOnion = bos.toByteArray();
            if (processedChannelOnion.length != packet.getChannelKeyOnion().length) {
                throw new DecryptionFailed("Processed channel onion came out shorter than expected.");
            }
            byte[] processedPayloadOnion = cipher.decryptBuffer(packet.getPayloadOnion());
            PublicKey newElement = packet.getPublicKey().blind(disposableKey);
            return new ProcessedInitPacket(this.channelID, packet.getMessageID(), requestChannelKey, responseChannelKey, newElement, processedChannelOnion, processedPayloadOnion);
        }
        catch (Exception e) {
            throw new DecryptionFailed("Couldn't decrypt init packet.", e);
        }
    }

    public static ProcessedDataPacket process(DataPacket packet, byte[] channelKey) throws DecryptionFailed {
        Counter counter = new Counter(packet.getMessageID());
        CTRCipher cipher = CTRCipher.getCipher(channelKey, counter.asIV(), false);
        try {
            return new ProcessedDataPacket(packet.getChannelID(), packet.getMessageID(), cipher.decryptBuffer(packet.getData()));
        }
        catch (InvalidCipherTextException e) {
            throw new DecryptionFailed("Could not decrypt data packet.", e);
        }
    }

    public DataPacket myprocess(DataPacket packet) throws DecryptionFailed {
        Counter counter = new Counter(packet.getMessageID());
        byte[] iv = counter.asIV();
        byte[] buff = packet.getData();
        try {
            for (int i = 0; i < this.m_arcipherDecrypt.length; ++i) {
                this.m_arcipherDecrypt[i].decryptBuffer(buff, buff, iv);
            }
            return packet;
        }
        catch (InvalidCipherTextException e) {
            throw new DecryptionFailed("Could not decrypt data packet.", e);
        }
    }

    public InitPacket makeInitPacket(Fragment fragment) throws PacketCreationFailed {
        this.requestCounter.count();
        PublicKey[] disposableKeys = new PublicKey[this.publicKeys.length];
        PrivateKey privateMessageKey = new PrivateKey();
        PublicKey publicMessageKey = new PublicKey(privateMessageKey);
        try {
            disposableKeys[0] = this.publicKeys[0].blind(privateMessageKey).blind(this.requestCounter.asBytes());
            for (int i = 1; i < this.publicKeys.length; ++i) {
                privateMessageKey = privateMessageKey.blind(disposableKeys[i - 1]);
                disposableKeys[i] = this.publicKeys[i].blind(privateMessageKey).blind(this.requestCounter.asBytes());
            }
            byte[] channelOnion = new byte[96];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            bos.write(this.initPayload);
            bos.write(fragment.toBytes());
            byte[] payloadOnion = bos.toByteArray();
            bos.close();
            bos = new ByteArrayOutputStream();
            for (int i = disposableKeys.length - 1; i >= 0; --i) {
                CTRCipher cipher = CTRCipher.getCipher(disposableKeys[i].toSymmetricKey(), this.requestCounter.asIV(), true);
                bos.write(this.requestChannelKeys[i]);
                bos.write(this.responseChannelKeys[i]);
                bos.write(Util.copyOf(channelOnion, channelOnion.length - 32));
                channelOnion = cipher.decryptBuffer(bos.toByteArray());
                payloadOnion = cipher.decryptBuffer(payloadOnion);
                bos.reset();
            }
            return new InitPacket(this.channelID, this.requestCounter.asBytes(), publicMessageKey, channelOnion, payloadOnion);
        }
        catch (Exception e) {
            throw new PacketCreationFailed("Couldn't create channel initialization packet.", e);
        }
    }

    public DataPacket makeDataPacket(Fragment fragment) throws PacketCreationFailed {
        try {
            byte[] encryptedFragment = fragment.toBytes();
            this.requestCounter.count();
            for (int i = this.mixCount - 1; i >= 0; --i) {
                CTRCipher cipher = CTRCipher.getCipher(this.requestChannelKeys[i], this.requestCounter.asIV(), true);
                encryptedFragment = cipher.encryptBuffer(encryptedFragment);
            }
            return new DataPacket(this.channelID, this.requestCounter.asBytes(), encryptedFragment);
        }
        catch (Exception e) {
            throw new PacketCreationFailed("Couldn't create data packet.", e);
        }
    }

    public byte[][] getRequestChannelKeys() {
        return this.requestChannelKeys;
    }

    public byte[][] getResponseChannelKeys() {
        return this.responseChannelKeys;
    }

    public int getChannelID() {
        return this.channelID;
    }
}

