/*
 * Decompiled with CFR 0.152.
 */
package anon.terms;

import anon.client.IllegalTCRequestPostConditionException;
import anon.infoservice.ServiceOperator;
import anon.terms.TermsAndConditions;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TermsAndConditionsRequest
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "Resources";
    public static final String XML_ELEMENT_CONTAINER_NAME = "TermsAndConditionsRequest";
    public static final String XML_ATTR_LOCALE = "locale";
    public static final String XML_ELEMENT_REQ_TRANSLATION = "Translation";
    public static final String XML_ELEMENT_RESOURCE_TEMPLATE = "Template";
    public static final String XML_ELEMENT_RESOURCE_CUSTOMIZED_SECT = "CustomizedSections";
    public static final String XML_MSG_TC_INTERRUPT = "TermsAndConditionsInterrupt";
    public static final String XML_MSG_TC_CONFIRM = "TermsAndConditionsConfirm";
    private Vector requestedTemplates = new Vector();
    private Hashtable requestedItems = new Hashtable();
    private Hashtable resourceRootElements = new Hashtable();

    public void addTemplateRequest(ServiceOperator operator, String langCode, String templateRefID) {
        if (!this.requestedTemplates.contains(templateRefID)) {
            this.requestedTemplates.addElement(templateRefID);
            this.addResourceRequest(XML_ELEMENT_RESOURCE_TEMPLATE, operator, langCode);
        }
    }

    public void addCustomizedSectionsRequest(ServiceOperator operator, String langCode) {
        this.addResourceRequest(XML_ELEMENT_RESOURCE_CUSTOMIZED_SECT, operator, langCode);
    }

    private void addResourceRequest(String resourceType, ServiceOperator operator, String langCode) {
        TCRequestKey reqKey = new TCRequestKey(operator, langCode);
        TCRequestValue reqValue = (TCRequestValue)this.requestedItems.get(reqKey);
        if (reqValue == null) {
            reqValue = new TCRequestValue();
            this.requestedItems.put(reqKey, reqValue);
        }
        reqValue.addResourceRequest(resourceType);
    }

    public boolean hasResourceRequests() {
        return !this.requestedItems.isEmpty();
    }

    public Element toXmlElement(Document a_doc) {
        Enumeration allReqs = this.requestedItems.keys();
        if (!allReqs.hasMoreElements()) {
            return null;
        }
        Element requestRoot = a_doc.createElement(XML_ELEMENT_CONTAINER_NAME);
        a_doc.appendChild(requestRoot);
        Element currRequestElement = null;
        Element currTranslationElement = null;
        Enumeration currRequestItems = null;
        TCRequestKey currTCReqKey = null;
        while (allReqs.hasMoreElements()) {
            currTCReqKey = (TCRequestKey)allReqs.nextElement();
            currRequestElement = (Element)this.resourceRootElements.get(currTCReqKey.getOperator());
            if (currRequestElement == null) {
                currRequestElement = a_doc.createElement(XML_ELEMENT_NAME);
                XMLUtil.setAttribute(currRequestElement, "id", currTCReqKey.getOperator().getId());
                this.resourceRootElements.put(currTCReqKey.getOperator(), currRequestElement);
            }
            if ((currRequestItems = ((TCRequestValue)this.requestedItems.get(currTCReqKey)).getAllResourceRequests()).hasMoreElements()) {
                currTranslationElement = a_doc.createElement(XML_ELEMENT_REQ_TRANSLATION);
                XMLUtil.setAttribute(currTranslationElement, XML_ATTR_LOCALE, currTCReqKey.getLangCode());
                currRequestElement.appendChild(currTranslationElement);
            }
            while (currRequestItems.hasMoreElements()) {
                currTranslationElement.appendChild(a_doc.createElement((String)currRequestItems.nextElement()));
            }
            requestRoot.appendChild(currRequestElement);
        }
        return requestRoot;
    }

    public void checkRequestPostCondition() throws IllegalTCRequestPostConditionException {
        IllegalTCRequestPostConditionException irpce = new IllegalTCRequestPostConditionException();
        Enumeration allResourceRequests = this.requestedItems.keys();
        TCRequestKey currentReqKey = null;
        TermsAndConditions currentTnCs = null;
        while (allResourceRequests.hasMoreElements()) {
            currentReqKey = (TCRequestKey)allResourceRequests.nextElement();
            currentTnCs = TermsAndConditions.getTermsAndConditions(currentReqKey.getOperator());
            if (currentTnCs != null) {
                if (!currentTnCs.hasTranslation(currentReqKey.getLangCode())) {
                    irpce.addErrorMessage("Requested Translation [" + currentReqKey.getLangCode() + "] was not loaded for terms and conditions of operator " + currentReqKey.getOperator().getOrganization());
                } else {
                    String templateRefid = currentTnCs.getTemplateReferenceId(currentReqKey.getLangCode());
                    if (templateRefid == null || TermsAndConditionsTemplate.getById(templateRefid, false) == null) {
                        irpce.addErrorMessage("Template '" + templateRefid + "' for translation [" + currentReqKey.getLangCode() + "] of terms and conditions of operator " + currentReqKey.getOperator().getOrganization() + " was not loaded.");
                    }
                }
                if (currentTnCs.hasDefaultTranslation()) continue;
                irpce.addErrorMessage("No default translation for terms and conditions of operator " + currentReqKey.getOperator().getOrganization() + " were loaded.");
                TermsAndConditions.removeTermsAndConditions(currentReqKey.getOperator());
                continue;
            }
            irpce.addErrorMessage("Translation for " + currentReqKey + " not loaded.");
        }
        if (irpce.hasErrorMessages()) {
            throw irpce;
        }
    }

    private static class TCRequestValue {
        Vector requestEntries = new Vector();

        private TCRequestValue() {
        }

        private void addResourceRequest(String resourceType) {
            if (!this.requestEntries.contains(resourceType)) {
                this.requestEntries.addElement(resourceType);
            }
        }

        private Enumeration getAllResourceRequests() {
            return this.requestEntries.elements();
        }
    }

    private static class TCRequestKey {
        ServiceOperator operator = null;
        String langCode = null;

        private TCRequestKey(ServiceOperator operator, String langCode) {
            this.operator = operator;
            this.langCode = langCode;
        }

        public String toString() {
            return this.operator.getId() + this.langCode;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object anotherKey) {
            return ((TCRequestKey)anotherKey).toString().equals(this.toString());
        }

        public String getLangCode() {
            return this.langCode;
        }

        public ServiceOperator getOperator() {
            return this.operator;
        }
    }
}

