/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.util.ClassUtil;
import anon.util.IResourceInstantiator;
import anon.util.IResourceLoaderHelper;
import anon.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import logging.LogHolder;
import logging.LogType;

public final class ResourceLoader {
    public static final String SYSTEM_RESOURCE_TYPE_ZIP = "zip";
    public static final String SYSTEM_RESOURCE_TYPE_JAR = "jar";
    public static final String SYSTEM_RESOURCE_TYPE_FILE = "file";
    public static final String SYSTEM_RESOURCE_TYPE_GENERIC = "systemresource";
    private static final String SYSTEM_RESOURCE = "systemresource:/";
    private static final String SYSTEM_RESOURCE_ENDSIGN = "/+/";
    private static final String DIR_UP = "../";
    private static final int READ_BUFFER = 2000;
    private static final String RESOURCE_NO_CLASSES_FOUND = "";
    private static Vector ms_classpathFiles;
    private static Object ms_classpathResourceLock;
    private static Vector ms_classpathResourceTypes;
    private static File ms_parentResourceFile;
    private static boolean ms_bTriedToLoadParentResourceFile;
    private static final Object SYNC_RESOURCE;
    private static String ms_parentResourceFileResourceURL;
    private static String ms_parentResourceFileResourceType;
    private static String ms_classpath;
    private static IResourceLoaderHelper ms_ResourceLoaderHelper;
    static /* synthetic */ Class class$anon$util$ResourceLoader;

    private ResourceLoader() {
        try {
            ms_parentResourceFile = new File(ClassUtil.getClassDirectory(class$anon$util$ResourceLoader == null ? (class$anon$util$ResourceLoader = ResourceLoader.class$("anon.util.ResourceLoader")) : class$anon$util$ResourceLoader).getAbsolutePath());
        }
        catch (Exception a_e) {
            ms_parentResourceFile = null;
        }
    }

    public static void setReourceLoaderHelper(IResourceLoaderHelper helper) {
        ms_ResourceLoaderHelper = helper;
    }

    public static Vector getFilesInClassPath() {
        try {
            return (Vector)ms_classpathFiles.clone();
        }
        catch (NullPointerException a_e) {
            return null;
        }
    }

    public static byte[] getStreamAsBytes(InputStream a_iStream) throws IOException {
        int readDataLength = 1;
        if (a_iStream == null) {
            throw new IOException("Stream is null!");
        }
        byte[] data = new byte[]{};
        while (readDataLength >= 0) {
            byte[] buffer = a_iStream.available() > 0 ? new byte[a_iStream.available()] : new byte[2000];
            readDataLength = a_iStream.read(buffer);
            data = ResourceLoader.trimByteArray(buffer, readDataLength, data);
        }
        a_iStream.close();
        return data;
    }

    public static URL getResourceURL(String a_strRelativeResourcePath) {
        File localFile;
        URL resourceURL = null;
        if ((a_strRelativeResourcePath = ResourceLoader.formatResourcePath(a_strRelativeResourcePath)) == null || a_strRelativeResourcePath.endsWith("/")) {
            return null;
        }
        resourceURL = (class$anon$util$ResourceLoader == null ? (class$anon$util$ResourceLoader = ResourceLoader.class$("anon.util.ResourceLoader")) : class$anon$util$ResourceLoader).getResource("/" + a_strRelativeResourcePath);
        if (resourceURL == null && (localFile = new File(a_strRelativeResourcePath)).exists() && localFile.canRead()) {
            try {
                resourceURL = new URL("file:" + localFile.getAbsolutePath());
            }
            catch (MalformedURLException a_e) {
                // empty catch block
            }
        }
        if (resourceURL == null && ResourceLoader.getParentResourceFile() != null && !ResourceLoader.readFilesFromClasspath(false).contains(ResourceLoader.getParentResourceFile())) {
            Vector<File> parentResourceFile = new Vector<File>();
            Vector<String> parentResourceFileURL = new Vector<String>();
            Vector<String> parentResourceFileType = new Vector<String>();
            parentResourceFile.addElement(ResourceLoader.getParentResourceFile());
            parentResourceFileURL.addElement(ms_parentResourceFileResourceURL);
            parentResourceFileType.addElement(ms_parentResourceFileResourceType);
            resourceURL = ResourceLoader.getResourceURL(a_strRelativeResourcePath, parentResourceFile, parentResourceFileURL, parentResourceFileType);
            ms_parentResourceFileResourceURL = (String)parentResourceFileURL.firstElement();
            ms_parentResourceFileResourceType = (String)parentResourceFileType.firstElement();
        }
        return resourceURL;
    }

    public static InputStream loadResourceAsStream(String a_strRelativeResourcePath) {
        return ResourceLoader.loadResourceAsStream(a_strRelativeResourcePath, false);
    }

    public static InputStream loadResourceAsStream(String a_strRelativeResourcePath, boolean a_bFileFirst) {
        String parent;
        File directory;
        InputStream in = null;
        if ((a_strRelativeResourcePath = ResourceLoader.formatResourcePath(a_strRelativeResourcePath)) == null || a_strRelativeResourcePath.endsWith("/")) {
            return null;
        }
        if (a_bFileFirst && ResourceLoader.getParentResourceFile() != null) {
            try {
                directory = ResourceLoader.getParentResourceFile();
                if (directory.isFile() && (parent = directory.getParent()) != null) {
                    directory = new File(parent);
                }
                in = new FileInputStream(new File(directory, ResourceLoader.replaceFileSeparatorsSystemSpecific(a_strRelativeResourcePath)));
            }
            catch (IOException a_e) {
                // empty catch block
            }
        }
        try {
            if (in == null) {
                in = (class$anon$util$ResourceLoader == null ? (class$anon$util$ResourceLoader = ResourceLoader.class$("anon.util.ResourceLoader")) : class$anon$util$ResourceLoader).getResourceAsStream("/" + a_strRelativeResourcePath);
            }
        }
        catch (Throwable a_e) {
            LogHolder.log(3, LogType.MISC, a_e);
        }
        try {
            if (in == null && !a_bFileFirst && ResourceLoader.getParentResourceFile() != null && !ResourceLoader.readFilesFromClasspath(false).contains(ResourceLoader.getParentResourceFile())) {
                directory = ResourceLoader.getParentResourceFile();
                if (directory.isFile() && (parent = directory.getParent()) != null) {
                    directory = new File(parent);
                }
                in = new FileInputStream(new File(directory, ResourceLoader.replaceFileSeparatorsSystemSpecific(a_strRelativeResourcePath)));
            }
        }
        catch (IOException a_e) {
            // empty catch block
        }
        try {
            if (in == null) {
                in = new FileInputStream(a_strRelativeResourcePath);
            }
            return in;
        }
        catch (IOException a_e) {
            return null;
        }
    }

    public static byte[] loadResource(String a_strRelativeResourcePath) {
        InputStream in = ResourceLoader.loadResourceAsStream(a_strRelativeResourcePath);
        byte[] retBytes = null;
        if (in == null) {
            return null;
        }
        try {
            retBytes = ResourceLoader.getStreamAsBytes(in);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Util.closeStream(in);
        return retBytes;
    }

    public static Hashtable loadResources(String a_strResourceSearchPath, boolean a_bRecursive) {
        return ResourceLoader.loadResources(a_strResourceSearchPath, new ResourceLoader().createByteArrayInstantiator(), a_bRecursive);
    }

    public static Hashtable loadResources(String a_strResourceSearchPath, IResourceInstantiator a_instantiator, boolean a_bRecursive) {
        Hashtable<String, Object> resources = new Hashtable<String, Object>();
        Object resource = null;
        InputStream inStream = null;
        try {
            inStream = ResourceLoader.loadResourceAsStream(a_strResourceSearchPath);
            resource = a_instantiator.getInstance(inStream, a_strResourceSearchPath);
        }
        catch (Exception a_e) {
            LogHolder.log(2, LogType.MISC, a_e);
        }
        Util.closeStream(inStream);
        if (resource != null) {
            resources.put(a_strResourceSearchPath, resource);
            return resources;
        }
        Enumeration classPathFiles = ResourceLoader.readFilesFromClasspath(false).elements();
        while (classPathFiles.hasMoreElements()) {
            ResourceLoader.loadResources(a_strResourceSearchPath, (File)classPathFiles.nextElement(), a_instantiator, a_bRecursive, false, resources);
        }
        ResourceLoader.loadResources(a_strResourceSearchPath, new File(ClassUtil.getUserDir()), a_instantiator, a_bRecursive, false, resources);
        if (ms_ResourceLoaderHelper != null) {
            ms_ResourceLoaderHelper.loadResources(a_strResourceSearchPath, null, a_instantiator, a_bRecursive, false, resources);
        }
        return resources;
    }

    public static Hashtable loadResources(String a_strResourceSearchPath, File a_directory, boolean a_bRecursive) {
        Hashtable resources = new Hashtable();
        ResourceLoader.loadResources(a_strResourceSearchPath, a_directory, new ResourceLoader().createByteArrayInstantiator(), a_bRecursive, false, resources);
        return resources;
    }

    public static Hashtable loadResources(String a_strResourceSearchPath, File a_directory, IResourceInstantiator a_instantiator, boolean a_bRecursive) {
        Hashtable resources = new Hashtable();
        ResourceLoader.loadResources(a_strResourceSearchPath, a_directory, a_instantiator, a_bRecursive, false, resources);
        return resources;
    }

    public static String replaceFileSeparatorsSystemSpecific(String a_filename) {
        if (a_filename == null) {
            return null;
        }
        a_filename = a_filename.replace('/', File.separatorChar);
        a_filename = a_filename.replace('\\', File.separatorChar);
        return a_filename;
    }

    protected static File getSystemResource(String a_systemResource) {
        if (a_systemResource.indexOf(SYSTEM_RESOURCE) != 0) {
            return null;
        }
        if ((a_systemResource = a_systemResource.substring(SYSTEM_RESOURCE.length(), a_systemResource.length())).toLowerCase().startsWith(SYSTEM_RESOURCE_TYPE_ZIP)) {
            a_systemResource = a_systemResource.substring(SYSTEM_RESOURCE_TYPE_ZIP.length(), a_systemResource.length());
        } else if (a_systemResource.toLowerCase().startsWith(SYSTEM_RESOURCE_TYPE_JAR)) {
            a_systemResource = a_systemResource.substring(SYSTEM_RESOURCE_TYPE_JAR.length(), a_systemResource.length());
        } else if (a_systemResource.toLowerCase().startsWith(SYSTEM_RESOURCE_TYPE_FILE)) {
            a_systemResource = a_systemResource.substring(SYSTEM_RESOURCE_TYPE_FILE.length(), a_systemResource.length());
        }
        int endIndex = a_systemResource.indexOf(SYSTEM_RESOURCE_ENDSIGN);
        if (endIndex >= 0) {
            a_systemResource = a_systemResource.substring(0, endIndex);
        }
        try {
            int resource = Integer.parseInt(a_systemResource);
            return (File)ResourceLoader.readFilesFromClasspath(true).elementAt(resource);
        }
        catch (Exception a_e) {
            return new File(a_systemResource);
        }
    }

    protected static void loadResources(String a_strResourceSearchPath, File a_Directory, IResourceInstantiator a_instantiator, boolean a_bRecursive, boolean a_bStopAtFirstResource, Hashtable a_loadedResources) {
        if ((a_strResourceSearchPath = ResourceLoader.formatResourcePath(a_strResourceSearchPath)) == null || a_loadedResources == null || a_Directory == null || a_instantiator == null || !a_Directory.exists() || !a_Directory.canRead()) {
            return;
        }
        try {
            Enumeration<ZipEntry> entries;
            ZipEntry zipentry;
            if (a_Directory.isDirectory()) {
                throw new IOException("This is a directory.");
            }
            ZipFile zipfile = new ZipFile(a_Directory);
            if (!a_strResourceSearchPath.endsWith("/")) {
                zipentry = zipfile.getEntry(a_strResourceSearchPath);
                if (zipentry == null) {
                    zipfile.close();
                    throw new IOException("Requested entry not found.");
                }
                Vector<ZipEntry> temp = new Vector<ZipEntry>();
                temp.addElement(zipentry);
                entries = temp.elements();
            } else {
                entries = zipfile.entries();
            }
            while (entries.hasMoreElements()) {
                String strCurrentResourcePath;
                zipentry = entries.nextElement();
                if (zipentry.isDirectory() || !ResourceLoader.isResourceInSearchPath(zipentry.toString(), a_strResourceSearchPath, a_bRecursive)) continue;
                Object object = null;
                try {
                    object = a_instantiator.getInstance(zipentry, zipfile);
                }
                catch (IResourceInstantiator.ResourceInstantiationException a_e) {
                    return;
                }
                catch (Exception a_e) {
                    // empty catch block
                }
                if (object == null || a_loadedResources.containsKey(strCurrentResourcePath = ResourceLoader.getCurrentResourcePath(zipentry))) continue;
                a_loadedResources.put(strCurrentResourcePath, object);
                if (a_strResourceSearchPath.endsWith("/") && !a_bStopAtFirstResource) continue;
                return;
            }
        }
        catch (Exception a_e) {
            try {
                ResourceLoader.loadResourcesFromFile(a_strResourceSearchPath, a_Directory, a_Directory, a_instantiator, a_loadedResources, a_bRecursive, a_bStopAtFirstResource);
            }
            catch (IResourceInstantiator.ResourceInstantiationException a_ex) {
                return;
            }
        }
    }

    private static void loadResourcesFromFile(String a_strResourceSearchPath, File a_file, File a_topDirectory, IResourceInstantiator a_instantiator, Hashtable a_loadedResources, boolean a_bRecursive, boolean a_bStopAtFirstResource) throws IResourceInstantiator.ResourceInstantiationException {
        if ((!a_strResourceSearchPath.endsWith("/") || a_bStopAtFirstResource) && a_loadedResources.size() > 0) {
            return;
        }
        if (a_file != null && a_file.exists()) {
            String strCurrentResourcePath = ResourceLoader.getCurrentResourcePath(a_file, a_topDirectory);
            if (strCurrentResourcePath.indexOf(a_strResourceSearchPath) != 0 && !a_strResourceSearchPath.equals("/")) {
                a_file = new File(a_topDirectory, ResourceLoader.replaceFileSeparatorsSystemSpecific(a_strResourceSearchPath));
                ResourceLoader.loadResourcesFromFile(a_strResourceSearchPath, a_file, a_topDirectory, a_instantiator, a_loadedResources, a_bRecursive, a_bStopAtFirstResource);
                return;
            }
            if (a_file.isFile() && ResourceLoader.isResourceInSearchPath(strCurrentResourcePath, a_strResourceSearchPath, a_bRecursive)) {
                Object object = null;
                if (a_loadedResources.containsKey(strCurrentResourcePath)) {
                    return;
                }
                try {
                    object = a_instantiator.getInstance(a_file, a_topDirectory);
                }
                catch (IResourceInstantiator.ResourceInstantiationException a_e) {
                    throw a_e;
                }
                catch (Exception a_e) {
                    // empty catch block
                }
                if (object != null) {
                    a_loadedResources.put(strCurrentResourcePath, object);
                    if (!a_strResourceSearchPath.endsWith("/") || a_bStopAtFirstResource) {
                        return;
                    }
                }
            } else if (a_file.isDirectory() && ResourceLoader.isResourceInSearchPath(strCurrentResourcePath, a_strResourceSearchPath, a_bRecursive)) {
                String[] filesArray = a_file.list();
                for (int i = 0; i < filesArray.length; ++i) {
                    String separatorChar = RESOURCE_NO_CLASSES_FOUND + File.separatorChar;
                    if (a_file.getAbsolutePath().endsWith(separatorChar)) {
                        separatorChar = RESOURCE_NO_CLASSES_FOUND;
                    }
                    ResourceLoader.loadResourcesFromFile(a_strResourceSearchPath, new File(a_file.getAbsolutePath() + separatorChar + filesArray[i]), a_topDirectory, a_instantiator, a_loadedResources, a_bRecursive, a_bStopAtFirstResource);
                }
            }
        }
    }

    private static URL getResourceURL(String a_strRelativeResourcePath, Vector a_resourceFiles, Vector a_resourceURLs, Vector a_resourceTypes) {
        Enumeration resourceFiles = a_resourceFiles.elements();
        FileTypeInstantiator instantiator = new ResourceLoader().createFileTypeInstantiator();
        int i = 0;
        while (resourceFiles.hasMoreElements()) {
            block11: {
                String classPathResourceURL;
                block8: {
                    File classPathFile;
                    block13: {
                        block12: {
                            block9: {
                                Class firstClassFound;
                                block10: {
                                    classPathFile = (File)resourceFiles.nextElement();
                                    classPathResourceURL = (String)a_resourceURLs.elementAt(i);
                                    if (classPathResourceURL != null) break block9;
                                    firstClassFound = ClassUtil.getFirstClassFound(classPathFile);
                                    if (firstClassFound != null) break block10;
                                    a_resourceURLs.setElementAt(RESOURCE_NO_CLASSES_FOUND, i);
                                    break block11;
                                }
                                String strRelativeResourcePath = ClassUtil.toRelativeResourcePath(firstClassFound);
                                Hashtable resourceType = new Hashtable();
                                ResourceLoader.loadResources(strRelativeResourcePath, classPathFile, instantiator, false, true, resourceType);
                                a_resourceTypes.setElementAt(resourceType.elements().nextElement(), i);
                                strRelativeResourcePath = "/" + strRelativeResourcePath;
                                classPathResourceURL = firstClassFound.getResource(strRelativeResourcePath).toString();
                                if (!classPathResourceURL.endsWith(strRelativeResourcePath)) break block11;
                                classPathResourceURL = classPathResourceURL.substring(0, classPathResourceURL.lastIndexOf(strRelativeResourcePath));
                                a_resourceURLs.setElementAt(classPathResourceURL, i);
                                break block12;
                            }
                            if (classPathResourceURL.trim().equals(RESOURCE_NO_CLASSES_FOUND)) break block11;
                        }
                        if (!a_resourceTypes.elementAt(i).equals(SYSTEM_RESOURCE_TYPE_FILE)) break block13;
                        File testfile = new File(classPathFile, ResourceLoader.replaceFileSeparatorsSystemSpecific(a_strRelativeResourcePath));
                        if (testfile.exists()) break block8;
                        break block11;
                    }
                    try {
                        ZipFile zipFile = new ZipFile(classPathFile);
                        if (zipFile.getEntry(a_strRelativeResourcePath) != null) {
                            zipFile.close();
                            break block8;
                        }
                        zipFile.close();
                    }
                    catch (IOException a_e) {
                    }
                    catch (IllegalStateException a_e) {}
                    break block11;
                }
                if (!a_strRelativeResourcePath.startsWith("/")) {
                    a_strRelativeResourcePath = "/" + a_strRelativeResourcePath;
                }
                try {
                    return new URL(classPathResourceURL + a_strRelativeResourcePath);
                }
                catch (MalformedURLException a_e) {
                    // empty catch block
                }
            }
            ++i;
        }
        return null;
    }

    private static String getCurrentResourcePath(File a_currentFile, File a_topDirectory) {
        if (a_currentFile.toString().equals(a_topDirectory.toString())) {
            return "/";
        }
        int separator = 1;
        if (a_topDirectory.toString().endsWith(File.separator)) {
            separator = 0;
        }
        String strCurrentFile = a_currentFile.toString().substring(a_topDirectory.toString().length() + separator, a_currentFile.toString().length());
        strCurrentFile = strCurrentFile.replace('\\', '/');
        if (a_currentFile.isDirectory() && !strCurrentFile.endsWith("/")) {
            strCurrentFile = strCurrentFile + "/";
        }
        return strCurrentFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File getParentResourceFile() {
        if (ms_parentResourceFile == null && !ms_bTriedToLoadParentResourceFile) {
            Object object = SYNC_RESOURCE;
            synchronized (object) {
                if (!ms_bTriedToLoadParentResourceFile) {
                    ms_bTriedToLoadParentResourceFile = true;
                    try {
                        ms_parentResourceFile = new File(ClassUtil.getClassDirectory(class$anon$util$ResourceLoader == null ? (class$anon$util$ResourceLoader = ResourceLoader.class$("anon.util.ResourceLoader")) : class$anon$util$ResourceLoader).getAbsolutePath());
                    }
                    catch (Throwable a_e) {
                        LogHolder.log(2, LogType.GUI, "Exception in ResourceLoader.getParentResourceFile(): " + a_e.getMessage(), a_e);
                    }
                }
            }
        }
        return ms_parentResourceFile;
    }

    private static String getCurrentResourcePath(ZipEntry a_currentEntry) {
        if (a_currentEntry.isDirectory() && !a_currentEntry.toString().endsWith("/")) {
            return a_currentEntry.toString() + "/";
        }
        return a_currentEntry.toString();
    }

    private static boolean isResourceInSearchPath(String a_strCurrentResourcePath, String a_strResourceSearchPath, boolean a_bRecursive) {
        if (a_strCurrentResourcePath.equals(a_strResourceSearchPath) || a_strCurrentResourcePath.equals("/")) {
            return true;
        }
        if (a_strResourceSearchPath.equals("/")) {
            if (a_bRecursive) {
                return true;
            }
            if (a_strCurrentResourcePath.indexOf("/") >= 0) {
                return false;
            }
        }
        if (a_strCurrentResourcePath.length() <= a_strResourceSearchPath.length()) {
            return false;
        }
        if (a_strCurrentResourcePath.startsWith(a_strResourceSearchPath) && a_strResourceSearchPath.endsWith("/")) {
            if (a_bRecursive) {
                return true;
            }
            if (a_strCurrentResourcePath.substring(a_strResourceSearchPath.length()).indexOf("/") < 0) {
                return true;
            }
        }
        return false;
    }

    public static String formatResourcePath(String a_strRelativeResourcePath) {
        int index;
        if (a_strRelativeResourcePath == null) {
            return null;
        }
        if ((a_strRelativeResourcePath = a_strRelativeResourcePath.trim().replace('\\', '/')).equals("/")) {
            return a_strRelativeResourcePath;
        }
        if (a_strRelativeResourcePath.length() == 0 || a_strRelativeResourcePath.startsWith("/")) {
            return null;
        }
        while ((index = a_strRelativeResourcePath.indexOf("/../")) >= 0) {
            if (a_strRelativeResourcePath.startsWith(DIR_UP)) {
                return null;
            }
            String temp = a_strRelativeResourcePath.substring(0, index);
            int tempIndex = temp.lastIndexOf("/");
            temp = tempIndex >= 0 ? temp.substring(0, tempIndex + 1) : "/";
            a_strRelativeResourcePath = temp = temp + a_strRelativeResourcePath.substring(index + "/../".length(), a_strRelativeResourcePath.length());
            while (a_strRelativeResourcePath.startsWith("/") && !a_strRelativeResourcePath.equals("/")) {
                a_strRelativeResourcePath = a_strRelativeResourcePath.substring(1, a_strRelativeResourcePath.length());
            }
        }
        if (a_strRelativeResourcePath.startsWith(DIR_UP)) {
            return null;
        }
        return a_strRelativeResourcePath;
    }

    private static byte[] trimByteArray(byte[] a_trimmedArray, int a_maxLength, byte[] a_arrayToAppendTo) {
        byte[] temp;
        if (a_maxLength <= 0) {
            temp = a_arrayToAppendTo;
        } else {
            int trimmedLength = a_trimmedArray.length > a_maxLength ? a_maxLength : a_trimmedArray.length;
            temp = new byte[a_arrayToAppendTo.length + trimmedLength];
            System.arraycopy(a_arrayToAppendTo, 0, temp, 0, a_arrayToAppendTo.length);
            System.arraycopy(a_trimmedArray, 0, temp, a_arrayToAppendTo.length, trimmedLength);
        }
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Vector readFilesFromClasspath(boolean a_bPreventLoop) {
        String classpath = ClassUtil.getClassPath(a_bPreventLoop);
        if (ms_classpath == null || !ms_classpath.equals(classpath)) {
            Object object = ms_classpathResourceLock;
            synchronized (object) {
                ms_classpath = classpath;
                ms_classpathFiles = new Vector();
                ms_classpathResourceTypes = new Vector();
                StringTokenizer tokenizer = new StringTokenizer(ms_classpath, File.pathSeparator);
                while (tokenizer.hasMoreTokens()) {
                    File tempPath = new File(new File(tokenizer.nextToken()).getAbsolutePath());
                    if (ms_classpathFiles.contains(tempPath)) continue;
                    ms_classpathFiles.addElement(tempPath);
                    ms_classpathResourceTypes.addElement(null);
                }
            }
        }
        return ms_classpathFiles;
    }

    private ByteArrayInstantiator createByteArrayInstantiator() {
        return new ByteArrayInstantiator();
    }

    private FileTypeInstantiator createFileTypeInstantiator() {
        return new FileTypeInstantiator();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_classpathResourceLock = new Object();
        ms_bTriedToLoadParentResourceFile = false;
        SYNC_RESOURCE = new Object();
        ms_ResourceLoaderHelper = null;
    }

    private final class FileTypeInstantiator
    implements IResourceInstantiator {
        private FileTypeInstantiator() {
        }

        public Object getInstance(File a_file, File a_topDirectory) {
            return ResourceLoader.SYSTEM_RESOURCE_TYPE_FILE;
        }

        public Object getInstance(ZipEntry a_entry, ZipFile a_file) {
            return ResourceLoader.SYSTEM_RESOURCE_TYPE_ZIP;
        }

        public Object getInstance(InputStream a_inputStream, String a_resourceName) {
            return null;
        }
    }

    private final class ByteArrayInstantiator
    implements IResourceInstantiator {
        private ByteArrayInstantiator() {
        }

        public Object getInstance(File a_file, File a_topDirectory) throws IOException {
            return ResourceLoader.getStreamAsBytes(new FileInputStream(a_file));
        }

        public Object getInstance(ZipEntry a_entry, ZipFile a_file) throws IOException {
            return ResourceLoader.getStreamAsBytes(a_file.getInputStream(a_entry));
        }

        public Object getInstance(InputStream a_inputStream, String a_resourceName) throws IOException {
            return ResourceLoader.getStreamAsBytes(a_inputStream);
        }
    }
}

