/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.client.TrustModel;
import anon.infoservice.Database;
import anon.infoservice.MixCascade;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.PopupMenu;
import jap.JAPController;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import logging.LogHolder;
import logging.LogType;

public class CascadePopupMenu
extends PopupMenu {
    private static final String MSG_EDIT_FILTER = (class$jap$JAPConfAnon == null ? (class$jap$JAPConfAnon = CascadePopupMenu.class$("jap.JAPConfAnon")) : class$jap$JAPConfAnon).getName() + "_editFilter";
    private final Color m_newCascadeColor = new Color(255, 255, 170);
    private final ImageIcon ICON_MANUELL = GUIUtils.loadImageIcon("servermanuell.gif");
    private final ImageIcon ICON_PAYMENT = GUIUtils.loadImageIcon("serverwithpayment.gif");
    private final ImageIcon ICON_INTERNET = GUIUtils.loadImageIcon("serverfrominternet.gif");
    private final ImageIcon ICON_SOCKS = GUIUtils.loadImageIcon("socks_icon.gif");
    private final ImageIcon ICON_SOCKS_MANUELL = GUIUtils.combine(this.ICON_MANUELL, this.ICON_SOCKS);
    private final ImageIcon ICON_SOCKS_PAYMENT = GUIUtils.combine(this.ICON_PAYMENT, this.ICON_SOCKS);
    private final ImageIcon ICON_SOCKS_INTERNET = GUIUtils.combine(this.ICON_INTERNET, this.ICON_SOCKS);
    private Hashtable m_menuItems = new Hashtable();
    private JMenuItem m_editFilter;
    private ActionListener m_cascadeItemListener = new CascadeItemListener();
    private TrustModel m_trustModel;
    private int m_headerHeight = 0;
    static /* synthetic */ Class class$jap$JAPConfAnon;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;
    static /* synthetic */ Class class$anon$infoservice$NewCascadeIDEntry;

    public CascadePopupMenu() {
        this(new JPopupMenu());
    }

    public CascadePopupMenu(boolean a_bCompatibilityMode) {
        super(a_bCompatibilityMode);
    }

    public CascadePopupMenu(JPopupMenu a_popup) {
        super(a_popup);
    }

    public TrustModel getTrustModel() {
        return this.m_trustModel;
    }

    public int getHeaderHeight() {
        return this.m_headerHeight;
    }

    public synchronized boolean update(TrustModel a_trustModel) {
        boolean updated = false;
        if (a_trustModel == null) {
            throw new IllegalArgumentException("Given argument is null!");
        }
        this.m_trustModel = a_trustModel;
        Hashtable hashCascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = CascadePopupMenu.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryHash();
        MixCascade currentCascade = JAPController.getInstance().getCurrentMixCascade();
        if (currentCascade != null && hashCascades.containsKey(currentCascade.getId())) {
            currentCascade = (MixCascade)hashCascades.get(currentCascade.getId());
        }
        Enumeration cascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = CascadePopupMenu.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntrySnapshotAsEnumeration();
        if (currentCascade != null || cascades.hasMoreElements()) {
            Vector<JMenuItem> vecFree = new Vector<JMenuItem>();
            this.removeAll();
            this.m_menuItems.clear();
            if (TrustModel.getTrustModels().size() > 1) {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBagConstraints constraints = new GridBagConstraints();
                constraints.gridx = 0;
                constraints.gridy = 0;
                constraints.anchor = 10;
                panel.add((Component)new JLabel(this.m_trustModel.getName()), constraints);
                this.add(panel);
                JSeparator separator = new JSeparator();
                this.addSeparator(separator);
                this.m_headerHeight = panel.getPreferredSize().height + separator.getPreferredSize().height;
            }
            MouseAdapter mouseAdapter = new MouseAdapter(){

                public void mouseEntered(MouseEvent a_event) {
                    ((JMenuItem)a_event.getSource()).setArmed(true);
                }

                public void mouseExited(MouseEvent a_event) {
                    ((JMenuItem)a_event.getSource()).setArmed(false);
                }
            };
            if (a_trustModel.isEditable()) {
                this.m_editFilter = new JMenuItem(JAPMessages.getString(MSG_EDIT_FILTER));
                this.m_editFilter.addMouseListener(mouseAdapter);
                this.m_editFilter.addActionListener(this.m_cascadeItemListener);
                this.m_editFilter.setIcon(GUIUtils.loadImageIcon("servermanuell.gif", true));
                this.add(this.m_editFilter);
                if (TrustModel.getTrustModels().size() <= 1) {
                    JSeparator separator = new JSeparator();
                    this.addSeparator(separator);
                    this.m_headerHeight = this.m_editFilter.getPreferredSize().height + separator.getPreferredSize().height;
                }
            }
            boolean bFreeOnTop = this.m_trustModel.hasFreeCascades();
            while (currentCascade != null || cascades.hasMoreElements()) {
                MixCascade cascade;
                ImageIcon icon = null;
                if (currentCascade != null) {
                    cascade = currentCascade;
                } else {
                    cascade = (MixCascade)cascades.nextElement();
                    if (!hashCascades.containsKey(cascade.getId()) || !this.m_trustModel.isTrusted(cascade)) continue;
                }
                hashCascades.remove(cascade.getId());
                icon = cascade.isUserDefined() ? (cascade.isSocks5Supported() ? this.ICON_SOCKS_MANUELL : this.ICON_MANUELL) : (cascade.isPayment() ? (cascade.isSocks5Supported() ? this.ICON_SOCKS_PAYMENT : this.ICON_PAYMENT) : (cascade.isSocks5Supported() ? this.ICON_SOCKS_INTERNET : this.ICON_INTERNET));
                JMenuItem menuItem = new JMenuItem(GUIUtils.trim(cascade.getName(), 35), icon);
                menuItem.addMouseListener(mouseAdapter);
                if (this.isNewCascade(cascade)) {
                    menuItem.setBackground(this.m_newCascadeColor);
                }
                if (currentCascade != null && currentCascade.equals(cascade)) {
                    menuItem.setFont(menuItem.getFont().deriveFont(1));
                    this.add(menuItem);
                    currentCascade = null;
                } else {
                    menuItem.setFont(menuItem.getFont().deriveFont(0));
                    if (bFreeOnTop && cascade.isPayment()) {
                        vecFree.addElement(menuItem);
                    } else {
                        this.add(menuItem);
                    }
                }
                menuItem.addActionListener(this.m_cascadeItemListener);
                this.m_menuItems.put(menuItem, cascade);
                updated = true;
            }
            for (int i = 0; i < vecFree.size(); ++i) {
                this.add((JMenuItem)vecFree.elementAt(i));
            }
        }
        if (updated) {
            try {
                this.pack();
            }
            catch (RuntimeException a_e) {
                LogHolder.log(3, LogType.GUI, a_e);
            }
        }
        return updated;
    }

    private boolean isNewCascade(MixCascade a_cascade) {
        return Database.getInstance(class$anon$infoservice$NewCascadeIDEntry == null ? (class$anon$infoservice$NewCascadeIDEntry = CascadePopupMenu.class$("anon.infoservice.NewCascadeIDEntry")) : class$anon$infoservice$NewCascadeIDEntry).getNumberOfEntries() * 2 < Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = CascadePopupMenu.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getNumberOfEntries() && Database.getInstance(class$anon$infoservice$NewCascadeIDEntry == null ? (class$anon$infoservice$NewCascadeIDEntry = CascadePopupMenu.class$("anon.infoservice.NewCascadeIDEntry")) : class$anon$infoservice$NewCascadeIDEntry).getEntryById(a_cascade.getMixIDsAsString()) != null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class CascadeItemListener
    implements ActionListener {
        private CascadeItemListener() {
        }

        public void actionPerformed(ActionEvent a_event) {
            if (a_event.getSource() == CascadePopupMenu.this.m_editFilter) {
                JAPController.getInstance().showConfigDialog("ANON_TAB", JAPController.getInstance().getCurrentMixCascade());
                CascadePopupMenu.this.dispose();
            } else {
                MixCascade cascade = (MixCascade)CascadePopupMenu.this.m_menuItems.get(a_event.getSource());
                if (cascade != null) {
                    TrustModel.setCurrentTrustModel(CascadePopupMenu.this.m_trustModel);
                    JAPController.getInstance().setCurrentMixCascade(cascade);
                    CascadePopupMenu.this.dispose();
                }
            }
        }
    }
}

