/*
 * Decompiled with CFR 0.152.
 */
package jarify;

import anon.crypto.JAPCertificate;
import anon.crypto.PKCS7SignedData;
import anon.util.Base64;
import jarify.JarFile;
import jarify.JarFileEntry;
import jarify.JarManifest;
import jarify.JarSignatureFile;
import java.io.File;
import java.io.IOException;
import java.security.SignatureException;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipException;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.crypto.Digest;

public final class JarVerifier {
    private JarFile m_jarFile;
    private JarManifest m_Manifest;
    private JAPCertificate m_certRoot = null;
    private Hashtable digestCache = new Hashtable();
    private Hashtable aliasSBF = new Hashtable();

    private JarVerifier(File jarFile) throws ZipException, IOException, SecurityException {
        this.m_jarFile = new JarFile(jarFile);
        this.m_Manifest = this.m_jarFile.getManifest();
    }

    private void close() {
        this.m_jarFile.close();
    }

    private Vector InitAliases(Vector aliases) {
        Vector<String> cerAliases = new Vector<String>();
        for (int i = 0; i < aliases.size(); ++i) {
            String alias = null;
            JAPCertificate[] certs = null;
            PKCS7SignedData block = null;
            alias = (String)aliases.elementAt(i);
            JarFileEntry sbf = this.m_jarFile.getSignatureBlockFile(alias);
            if (sbf == null) continue;
            LogHolder.log(7, LogType.MISC, "Checking certificate chain for alias: " + alias);
            try {
                block = new PKCS7SignedData(sbf.getContent());
            }
            catch (Exception ex) {
                LogHolder.log(7, LogType.MISC, ex.getMessage());
                continue;
            }
            if (block == null) {
                LogHolder.log(7, LogType.MISC, "Could not get PKCS#7 data object!");
                continue;
            }
            this.aliasSBF.put(alias, block);
            certs = block.getCertificates();
            if (certs == null) continue;
            try {
                certs[certs.length - 1].verify(this.m_certRoot.getPublicKey());
            }
            catch (Exception ex) {
                LogHolder.log(7, LogType.MISC, ex.getMessage());
                continue;
            }
            try {
                for (int j = 0; j < certs.length - 1; ++j) {
                    LogHolder.log(7, LogType.MISC, "Checking certificate No. : " + j + 1);
                    certs[j].verify(certs[j + 1].getPublicKey());
                    LogHolder.log(7, LogType.MISC, "Certificate No. " + j + 1 + " verified OK.");
                }
            }
            catch (Exception ex) {
                LogHolder.log(7, LogType.MISC, ex.getMessage());
                continue;
            }
            cerAliases.addElement(alias);
        }
        return cerAliases;
    }

    public static boolean verify(File file, JAPCertificate cert) {
        try {
            JarVerifier jv = new JarVerifier(file);
            boolean b = jv.verify(cert);
            jv.close();
            return b;
        }
        catch (Throwable t) {
            LogHolder.log(0, LogType.MISC, t);
            return false;
        }
    }

    private boolean verify(JAPCertificate cert) {
        this.m_certRoot = cert;
        if (this.m_certRoot == null) {
            return false;
        }
        LogHolder.log(7, LogType.MISC, "Searching for Signatures...");
        if (!this.isSignedJar()) {
            return false;
        }
        LogHolder.log(7, LogType.MISC, "This is a signed Jarfile.\n");
        LogHolder.log(7, LogType.MISC, "Verifying Manifest entries...");
        if (!this.verifyManifestDigests()) {
            return false;
        }
        LogHolder.log(7, LogType.MISC, "Manifest entries verified OK.\n");
        Vector cerAliases = this.InitAliases(this.m_jarFile.getAliasList());
        if (cerAliases.size() < 1) {
            LogHolder.log(7, LogType.MISC, "\nNo Aliases present that can be validated with the given root certificate!\n");
            return false;
        }
        String alias = null;
        for (int n = 0; n < cerAliases.size(); ++n) {
            alias = (String)cerAliases.elementAt(n);
            if (alias == null || alias == "") {
                LogHolder.log(7, LogType.MISC, "\nAlias error");
                return false;
            }
            LogHolder.log(7, LogType.MISC, "Verifying Signature File entries for alias \"" + alias + "\"...");
            if (!this.verifySFDigests(alias)) {
                return false;
            }
            LogHolder.log(7, LogType.MISC, "Entries verified OK.");
            LogHolder.log(7, LogType.MISC, "Verifying Signature for alias \"" + alias + "\"...");
            if (!this.verifySignature(alias)) {
                return false;
            }
            LogHolder.log(7, LogType.MISC, "Signature from \"" + alias + "\" is genuine.\n");
        }
        return true;
    }

    private boolean verifySignature(String alias) {
        boolean sig_ok = false;
        JarSignatureFile sf = this.m_jarFile.getSignatureFile(alias);
        if (sf == null) {
            return false;
        }
        JarFileEntry sbf = this.m_jarFile.getSignatureBlockFile(alias);
        if (sbf == null) {
            return false;
        }
        byte[] sfBytes = sf.getContent();
        if (sfBytes == null) {
            return false;
        }
        String sbfName = sbf.getName();
        if (sbfName.endsWith(".DSA") || sbfName.endsWith(".RSA")) {
            LogHolder.log(7, LogType.MISC, "Found " + sbfName.substring(sbfName.lastIndexOf(".") + 1) + " signature in : " + sbfName);
            try {
                PKCS7SignedData block = (PKCS7SignedData)this.aliasSBF.get(alias);
                sig_ok = block.verify(sfBytes);
                if (!sig_ok) {
                    LogHolder.log(7, LogType.MISC, "Wrong Signature in " + sbfName);
                    return false;
                }
                LogHolder.log(7, LogType.MISC, "Signature in " + sbfName + " verified OK.");
            }
            catch (SignatureException ex) {
                return false;
            }
        }
        return sig_ok;
    }

    private boolean isSignedJar() {
        if (this.m_jarFile == null) {
            return false;
        }
        Vector aliases = this.m_jarFile.getAliasList();
        String[] algs = new String[]{".DSA", ".RSA"};
        if (aliases.size() < 1) {
            return false;
        }
        if (!this.m_jarFile.fileExists("META-INF/MANIFEST.MF")) {
            return false;
        }
        for (int i = 0; i < aliases.size(); ++i) {
            boolean found = false;
            String name = "META-INF/" + aliases.elementAt(i);
            name = name.toUpperCase();
            for (int j = 0; j < algs.length; ++j) {
                if (!this.m_jarFile.fileExists(name + algs[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    private boolean verifySFDigests(String alias) {
        String digString;
        JarSignatureFile signatureFile = this.m_jarFile.getSignatureFile(alias);
        if (signatureFile == null) {
            return false;
        }
        Vector digList = signatureFile.getManifestDigestList();
        for (int j = 0; j < digList.size(); ++j) {
            digString = (String)digList.elementAt(j);
            String manDigest = signatureFile.getManifestDigest(digString);
            Digest digest = this.getDigestClass(digString);
            byte[] hash2 = new byte[digest.getDigestSize()];
            try {
                byte[] manifestContent = this.m_Manifest.getContent();
                if (manifestContent == null) {
                    LogHolder.log(7, LogType.MISC, "Manifest file null.");
                    return false;
                }
                digest.update(manifestContent, 0, manifestContent.length);
                digest.doFinal(hash2, 0);
                String strEncoded = new String(Base64.encode(hash2, false));
                if (manDigest.equals(strEncoded)) continue;
                LogHolder.log(2, LogType.MISC, "Digest verify failed for manifest file. Digest:\n" + manDigest + "\n\nHash:\n" + strEncoded);
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        Vector listSig = signatureFile.getFileNames();
        for (int i = 0; i < listSig.size(); ++i) {
            String fileName = (String)listSig.elementAt(i);
            digList = this.m_Manifest.getDigestList(fileName);
            for (int j = 0; j < digList.size(); ++j) {
                digString = (String)digList.elementAt(j);
                String sigDigest = signatureFile.getDigest(fileName, digString);
                byte[] manEntry = this.m_Manifest.getEntry(fileName);
                Digest digest = this.getDigestClass(digString);
                byte[] sha1 = new byte[digest.getDigestSize()];
                try {
                    digest.update(manEntry, 0, manEntry.length);
                    digest.doFinal(sha1, 0);
                    String strEncoded = new String(Base64.encode(sha1, false));
                    if (sigDigest.equals(strEncoded)) continue;
                    LogHolder.log(2, LogType.MISC, "Digest verify failed for " + fileName + ". Digest:\n" + sigDigest + "\n\nHash:\n" + strEncoded);
                    LogHolder.log(7, LogType.MISC, digString);
                    LogHolder.log(7, LogType.MISC, sigDigest);
                    return false;
                }
                catch (Exception e) {
                    return false;
                }
            }
        }
        return true;
    }

    private boolean verifyManifestDigests() {
        Vector fileList = this.m_Manifest.getFileNames();
        for (int i = 0; i < fileList.size(); ++i) {
            String fileName = (String)fileList.elementAt(i);
            JarFileEntry fileEntry = this.m_jarFile.getFileByName(fileName);
            if (fileEntry == null) {
                return false;
            }
            Vector digList = this.m_Manifest.getDigestList(fileName);
            for (int j = 0; j < digList.size(); ++j) {
                String digString = (String)digList.elementAt(j);
                String manDigest = this.m_Manifest.getDigest(fileEntry, digString);
                Digest digest = this.getDigestClass(digString);
                byte[] sha1 = new byte[digest.getDigestSize()];
                try {
                    byte[] fileContent = fileEntry.getContent();
                    if (fileContent == null) {
                        return false;
                    }
                    digest.update(fileContent, 0, fileContent.length);
                    digest.doFinal(sha1, 0);
                    String strEncoded = new String(Base64.encode(sha1, false));
                    if (manDigest.equals(strEncoded)) continue;
                    LogHolder.log(2, LogType.MISC, "Digest verify failed for " + fileName + ". Digest:\n" + manDigest + "\n\nHash:\n" + strEncoded);
                    return false;
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.MISC, e);
                    return false;
                }
            }
        }
        return true;
    }

    private Digest getDigestClass(String digestID) {
        int hyphen;
        while ((hyphen = digestID.indexOf("-")) >= 0) {
            digestID = digestID.substring(0, hyphen) + digestID.substring(hyphen + 1);
        }
        if (this.digestCache.contains(digestID)) {
            Digest dig = (Digest)this.digestCache.get(digestID);
            dig.reset();
            return dig;
        }
        try {
            Class<?> digest = Class.forName("org.bouncycastle.crypto.digests." + digestID);
            Digest digObj = (Digest)digest.newInstance();
            this.digestCache.put(digestID, digObj);
            return digObj;
        }
        catch (ClassNotFoundException e) {
            LogHolder.log(0, LogType.CRYPTO, e);
        }
        catch (IllegalAccessException e) {
            LogHolder.log(0, LogType.CRYPTO, e);
        }
        catch (InstantiationException e) {
            LogHolder.log(0, LogType.CRYPTO, e);
        }
        return null;
    }
}

