/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oro.text.regex;

import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.StringSubstitution;

public class Perl5Substitution
extends StringSubstitution {
    public static final int INTERPOLATE_ALL = 0;
    public static final int INTERPOLATE_NONE = -1;
    private static final int __OPCODE_STORAGE_SIZE = 32;
    private static final int __MAX_GROUPS = 65535;
    static final int _OPCODE_COPY = -1;
    static final int _OPCODE_LOWERCASE_CHAR = -2;
    static final int _OPCODE_UPPERCASE_CHAR = -3;
    static final int _OPCODE_LOWERCASE_MODE = -4;
    static final int _OPCODE_UPPERCASE_MODE = -5;
    static final int _OPCODE_ENDCASE_MODE = -6;
    int _numInterpolations;
    int[] _subOpcodes;
    int _subOpcodesCount;
    char[] _substitutionChars;
    transient String _lastInterpolation;

    private static final boolean __isInterpolationCharacter(char ch) {
        return Character.isDigit(ch) || ch == '&';
    }

    private void __addElement(int value) {
        int len = this._subOpcodes.length;
        if (this._subOpcodesCount == len) {
            int[] newarray = new int[len + 32];
            System.arraycopy(this._subOpcodes, 0, newarray, 0, len);
            this._subOpcodes = newarray;
        }
        this._subOpcodes[this._subOpcodesCount++] = value;
    }

    private void __parseSubs(String sub) {
        this._substitutionChars = sub.toCharArray();
        char[] subChars = this._substitutionChars;
        int subLength = subChars.length;
        this._subOpcodes = new int[32];
        this._subOpcodesCount = 0;
        int posParam = 0;
        int offset = -1;
        boolean saveDigits = false;
        boolean escapeMode = false;
        boolean caseMode = false;
        for (int current = 0; current < subLength; ++current) {
            char c = subChars[current];
            int next = current + 1;
            if (saveDigits) {
                int digit = Character.digit(c, 10);
                if (digit > -1) {
                    if (posParam <= 65535) {
                        posParam *= 10;
                        posParam += digit;
                    }
                    if (next != subLength) continue;
                    this.__addElement(posParam);
                    continue;
                }
                if (c == '&' && subChars[current - 1] == '$') {
                    this.__addElement(0);
                    posParam = 0;
                    saveDigits = false;
                    continue;
                }
                this.__addElement(posParam);
                posParam = 0;
                saveDigits = false;
            }
            if (c != '$' && c != '\\' || escapeMode) {
                escapeMode = false;
                if (offset < 0) {
                    offset = current;
                    this.__addElement(-1);
                    this.__addElement(offset);
                }
                if (next != subLength) continue;
                this.__addElement(next - offset);
                continue;
            }
            if (offset >= 0) {
                this.__addElement(current - offset);
                offset = -1;
            }
            if (next == subLength) continue;
            char nextc = subChars[next];
            if (c == '$') {
                saveDigits = Perl5Substitution.__isInterpolationCharacter(nextc);
                continue;
            }
            if (c != '\\') continue;
            if (nextc == 'l') {
                if (caseMode) continue;
                this.__addElement(-2);
                ++current;
                continue;
            }
            if (nextc == 'u') {
                if (caseMode) continue;
                this.__addElement(-3);
                ++current;
                continue;
            }
            if (nextc == 'L') {
                this.__addElement(-4);
                ++current;
                caseMode = true;
                continue;
            }
            if (nextc == 'U') {
                this.__addElement(-5);
                ++current;
                caseMode = true;
                continue;
            }
            if (nextc == 'E') {
                this.__addElement(-6);
                ++current;
                caseMode = false;
                continue;
            }
            escapeMode = true;
        }
    }

    String _finalInterpolatedSub(MatchResult result) {
        StringBuffer buffer = new StringBuffer(10);
        this._calcSub(buffer, result);
        return buffer.toString();
    }

    void _calcSub(StringBuffer buffer, MatchResult result) {
        int[] subOpcodes = this._subOpcodes;
        int caseMode = 0;
        char[] str = this._substitutionChars;
        char[] match = result.group(0).toCharArray();
        int size = this._subOpcodesCount;
        for (int element = 0; element < size; ++element) {
            char[] sub;
            int count;
            int end;
            int offset;
            int value = subOpcodes[element];
            if (value >= 0 && value < result.groups()) {
                int len;
                offset = result.begin(value);
                if (offset < 0 || (end = result.end(value)) < 0 || offset >= (len = result.length()) || end > len || offset >= end) continue;
                count = end - offset;
                sub = match;
            } else if (value == -1) {
                if (++element >= size) continue;
                offset = subOpcodes[element];
                if (++element >= size) continue;
                count = subOpcodes[element];
                sub = str;
            } else {
                if (value == -2 || value == -3) {
                    if (caseMode == -4 || caseMode == -5) continue;
                    caseMode = value;
                    continue;
                }
                if (value == -4 || value == -5) {
                    caseMode = value;
                    continue;
                }
                if (value != -6) continue;
                caseMode = 0;
                continue;
            }
            if (caseMode == -2) {
                buffer.append(Character.toLowerCase(sub[offset++]));
                buffer.append(sub, offset, --count);
                caseMode = 0;
                continue;
            }
            if (caseMode == -3) {
                buffer.append(Character.toUpperCase(sub[offset++]));
                buffer.append(sub, offset, --count);
                caseMode = 0;
                continue;
            }
            if (caseMode == -4) {
                end = offset + count;
                while (offset < end) {
                    buffer.append(Character.toLowerCase(sub[offset++]));
                }
                continue;
            }
            if (caseMode == -5) {
                end = offset + count;
                while (offset < end) {
                    buffer.append(Character.toUpperCase(sub[offset++]));
                }
                continue;
            }
            buffer.append(sub, offset, count);
        }
    }

    public Perl5Substitution() {
        this("", 0);
    }

    public Perl5Substitution(String substitution) {
        this(substitution, 0);
    }

    public Perl5Substitution(String substitution, int numInterpolations) {
        this.setSubstitution(substitution, numInterpolations);
    }

    public void setSubstitution(String substitution) {
        this.setSubstitution(substitution, 0);
    }

    public void setSubstitution(String substitution, int numInterpolations) {
        super.setSubstitution(substitution);
        this._numInterpolations = numInterpolations;
        if (numInterpolations != -1 && (substitution.indexOf(36) != -1 || substitution.indexOf(92) != -1)) {
            this.__parseSubs(substitution);
        } else {
            this._subOpcodes = null;
        }
        this._lastInterpolation = null;
    }

    public void appendSubstitution(StringBuffer appendBuffer, MatchResult match, int substitutionCount, PatternMatcherInput originalInput, PatternMatcher matcher, Pattern pattern) {
        if (this._subOpcodes == null) {
            super.appendSubstitution(appendBuffer, match, substitutionCount, originalInput, matcher, pattern);
            return;
        }
        if (this._numInterpolations < 1 || substitutionCount < this._numInterpolations) {
            this._calcSub(appendBuffer, match);
        } else {
            if (substitutionCount == this._numInterpolations) {
                this._lastInterpolation = this._finalInterpolatedSub(match);
            }
            appendBuffer.append(this._lastInterpolation);
        }
    }
}

