/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.HTTPConnection;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.Serializable;
import java.net.ProtocolException;
import java.util.Date;

public class Cookie
implements Serializable {
    protected String name;
    protected String value;
    protected Date expires;
    protected String domain;
    protected String path;
    protected boolean secure;
    protected boolean httponly;

    public Cookie(String name, String value, String domain, String path, Date expires, boolean secure, boolean httponly) {
        if (name == null) {
            throw new NullPointerException("missing name");
        }
        if (value == null) {
            throw new NullPointerException("missing value");
        }
        if (domain == null) {
            throw new NullPointerException("missing domain");
        }
        if (path == null) {
            throw new NullPointerException("missing path");
        }
        this.name = name;
        this.value = value;
        this.domain = domain;
        this.path = path;
        this.expires = expires;
        this.secure = secure;
        this.httponly = httponly;
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
    }

    protected Cookie(RoRequest req) {
        this.name = null;
        this.value = null;
        this.expires = null;
        this.domain = req.getConnection().getHost();
        if (this.domain.indexOf(46) == -1) {
            this.domain = this.domain + ".local";
        }
        this.path = Util.getPath(req.getRequestURI());
        String prot = req.getConnection().getProtocol();
        this.secure = prot.equals("https") || prot.equals("shttp");
    }

    protected static Cookie[] parse(String set_cookie, RoRequest req) throws ProtocolException {
        int beg = 0;
        int end = 0;
        int start = 0;
        char[] buf = set_cookie.toCharArray();
        int len = buf.length;
        Cookie[] cookie_arr = new Cookie[]{};
        while ((beg = Util.skipSpace(buf, beg)) < len) {
            if (buf[beg] == ',') {
                ++beg;
                continue;
            }
            Cookie curr = new Cookie(req);
            start = beg;
            boolean legal = true;
            while (beg < len && buf[beg] != ',') {
                int c;
                if (buf[beg] == ';') {
                    beg = Util.skipSpace(buf, beg + 1);
                    continue;
                }
                if (set_cookie.regionMatches(true, beg, "secure", 0, 6)) {
                    curr.secure = true;
                    beg += 6;
                    if ((beg = Util.skipSpace(buf, beg)) < len && buf[beg] == ';') {
                        beg = Util.skipSpace(buf, beg + 1);
                        continue;
                    }
                    if (beg >= len || buf[beg] == ',') continue;
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nExpected " + "';' or ',' at position " + beg);
                }
                if (set_cookie.regionMatches(true, beg, "HttpOnly", 0, 8)) {
                    curr.httponly = true;
                    beg += 8;
                    if ((beg = Util.skipSpace(buf, beg)) < len && buf[beg] == ';') {
                        beg = Util.skipSpace(buf, beg + 1);
                        continue;
                    }
                    if (beg >= len || buf[beg] == ',') continue;
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nExpected " + "';' or ',' at position " + beg);
                }
                end = set_cookie.indexOf(61, beg);
                if (end == -1) {
                    throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo '=' found " + "for token starting at " + "position " + beg);
                }
                String name = set_cookie.substring(beg, end).trim();
                beg = Util.skipSpace(buf, end + 1);
                if (name.equalsIgnoreCase("expires") && (c = set_cookie.indexOf(44, beg)) != -1) {
                    beg = c + 1;
                }
                int comma = set_cookie.indexOf(44, beg);
                int semic = set_cookie.indexOf(59, beg);
                end = comma == -1 && semic == -1 ? len : (comma == -1 ? semic : (semic == -1 ? comma : Math.min(comma, semic)));
                String value = set_cookie.substring(beg, end).trim();
                if (name.equalsIgnoreCase("expires")) {
                    try {
                        curr.expires = Util.parseDate(value);
                    }
                    catch (IllegalArgumentException iae) {}
                } else if (name.equalsIgnoreCase("domain")) {
                    if ((value = value.toLowerCase()).charAt(0) != '.' && !value.equals(curr.domain)) {
                        value = '.' + value;
                    }
                    if (!curr.domain.endsWith(value)) {
                        legal = false;
                    }
                    if (!value.equals(".local") && value.indexOf(46, 1) == -1) {
                        legal = false;
                    }
                    String top = null;
                    if (value.length() > 3) {
                        top = value.substring(value.length() - 4);
                    }
                    if (!(top != null && (top.equalsIgnoreCase(".com") || top.equalsIgnoreCase(".edu") || top.equalsIgnoreCase(".net") || top.equalsIgnoreCase(".org") || top.equalsIgnoreCase(".gov") || top.equalsIgnoreCase(".mil") || top.equalsIgnoreCase(".int")) || curr.domain.substring(0, curr.domain.length() - value.length()).indexOf(46) == -1)) {
                        legal = false;
                    }
                    curr.domain = value;
                } else if (name.equalsIgnoreCase("path")) {
                    curr.path = value;
                } else {
                    curr.name = name;
                    curr.value = value;
                }
                if ((beg = end) >= len || buf[beg] != ';') continue;
                beg = Util.skipSpace(buf, beg + 1);
            }
            if (curr.name == null || curr.value == null) {
                throw new ProtocolException("Bad Set-Cookie header: " + set_cookie + "\nNo Name=Value found" + " for cookie starting at " + "posibition " + start);
            }
            if (!legal) continue;
            cookie_arr = Util.resizeArray(cookie_arr, cookie_arr.length + 1);
            cookie_arr[cookie_arr.length - 1] = curr;
        }
        return cookie_arr;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public Date expires() {
        return this.expires;
    }

    public boolean discard() {
        return this.expires == null;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isHttpOnly() {
        return this.httponly;
    }

    public boolean hasExpired() {
        return this.expires != null && this.expires().before(new Date());
    }

    protected boolean sendWith(RoRequest req) {
        HTTPConnection con = req.getConnection();
        String eff_host = con.getHost();
        if (eff_host.indexOf(46) == -1) {
            eff_host = eff_host + ".local";
        }
        return (this.domain.charAt(0) == '.' && eff_host.endsWith(this.domain) || this.domain.charAt(0) != '.' && eff_host.equals(this.domain)) && Util.getPath(req.getRequestURI()).startsWith(this.path) && (!this.secure || con.getProtocol().equals("https") || con.getProtocol().equals("shttp"));
    }

    public int hashCode() {
        return this.name.hashCode() + this.path.hashCode() + this.domain.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Cookie) {
            Cookie other = (Cookie)obj;
            return this.name.equals(other.name) && this.path.equals(other.path) && this.domain.equals(other.domain);
        }
        return false;
    }

    protected String toExternalForm() {
        return this.name + "=" + this.value;
    }

    public String toString() {
        String string = this.name + "=" + this.value;
        if (this.expires != null) {
            string = string + "; expires=" + this.expires;
        }
        if (this.path != null) {
            string = string + "; path=" + this.path;
        }
        if (this.domain != null) {
            string = string + "; domain=" + this.domain;
        }
        if (this.secure) {
            string = string + "; secure";
        }
        return string;
    }
}

