/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.GlobalConstants;
import HTTPClient.HTTPClientModule;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.Util;
import java.io.IOException;
import java.net.ProtocolException;

class DefaultModule
implements HTTPClientModule,
GlobalConstants {
    private int req_timeout_retries = 3;

    DefaultModule() {
    }

    public int requestHandler(Request req, Response[] resp) {
        return 0;
    }

    public void responsePhase1Handler(Response resp, RoRequest req) {
    }

    public int responsePhase2Handler(Response resp, Request req) throws IOException {
        int sts = resp.getStatusCode();
        switch (sts) {
            case 408: {
                if (this.req_timeout_retries-- == 0 || req.getStream() != null) {
                    if (GlobalConstants.DebugMods) {
                        Util.logLine("DefM:  Status " + sts + " " + resp.getReasonLine() + " not handled - " + "maximum number of retries exceeded");
                    }
                    return 10;
                }
                if (GlobalConstants.DebugMods) {
                    Util.logLine("DefM:  Handling " + sts + " " + resp.getReasonLine() + " - " + "resending request");
                }
                return 13;
            }
            case 411: {
                if (req.getStream() != null && req.getStream().getLength() == -1) {
                    return 10;
                }
                try {
                    resp.getInputStream().close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (req.getData() != null) {
                    throw new ProtocolException("Received status code 411 even though Content-Length was sent");
                }
                if (GlobalConstants.DebugMods) {
                    Util.logLine("DefM:  Handling " + sts + " " + resp.getReasonLine() + " - resending " + "request with 'Content-length: 0'");
                }
                req.setData(new byte[0]);
                return 13;
            }
            case 505: {
                return 10;
            }
        }
        return 10;
    }

    public void responsePhase3Handler(Response resp, RoRequest req) {
    }

    public void trailerHandler(Response resp, RoRequest req) {
    }
}

