/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractPrivateKey;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.ISignatureCreationAlgorithm;
import anon.crypto.MyDSAParams;
import anon.crypto.MyDSAPublicKey;
import anon.crypto.MyDSASignature;
import anon.util.Base64;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.params.DSAParameters;
import org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class MyDSAPrivateKey
extends AbstractPrivateKey
implements DSAPrivateKey,
IMyPrivateKey {
    public static final String XML_ELEMENT_NAME = "DSAPrivateKey";
    private BigInteger m_X;
    private MyDSAParams m_params;

    public MyDSAPrivateKey(PrivateKeyInfo privKeyInfo) throws InvalidKeyException {
        super(privKeyInfo);
        try {
            AlgorithmIdentifier algId = privKeyInfo.getPrivateKeyAlgorithm();
            ASN1Integer X = (ASN1Integer)privKeyInfo.parsePrivateKey();
            this.m_X = X.getValue();
            this.m_params = new MyDSAParams(DSAParameter.getInstance(algId.getParameters()));
        }
        catch (Exception e) {
            throw new InvalidKeyException("IOException while decoding private key");
        }
    }

    public MyDSAPrivateKey(Element a_xmlElement) throws InvalidKeyException, XMLParseException {
        if (a_xmlElement == null || !a_xmlElement.getNodeName().equals(XML_ELEMENT_NAME)) {
            throw new XMLParseException(XML_ELEMENT_NAME, "Element is null or has wrong name!");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "G");
        String str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger g = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "P");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger p = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "Q");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        BigInteger q = new BigInteger(Base64.decode(str));
        elem = (Element)XMLUtil.getFirstChildByName(a_xmlElement, "X");
        str = XMLUtil.parseValue((Node)elem, (String)null);
        this.m_X = new BigInteger(Base64.decode(str));
        this.m_params = new MyDSAParams(new DSAPrivateKeyParameters(this.m_X, new DSAParameters(p, q, g)).getParameters());
    }

    public MyDSAPrivateKey(DSAPrivateKeyParameters keyParams) {
        this.m_X = keyParams.getX();
        this.m_params = new MyDSAParams(keyParams.getParameters());
    }

    public IMyPublicKey createPublicKey() {
        BigInteger Y = this.getParams().getG().modPow(this.getX(), this.getParams().getP());
        MyDSAPublicKey key = new MyDSAPublicKey(new DSAPublicKeyParameters(Y, (DSAParameters)this.m_params));
        return key;
    }

    public String getAlgorithm() {
        return "DSA";
    }

    public String getFormat() {
        return "PKCS#8";
    }

    public BigInteger getX() {
        return this.m_X;
    }

    public PrivateKeyInfo getAsPrivateKeyInfo() {
        PrivateKeyInfo info;
        ASN1Primitive derParam = new DSAParameter(this.m_params.getP(), this.m_params.getQ(), this.m_params.getG()).toASN1Primitive();
        try {
            info = new PrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, derParam), new ASN1Integer(this.getX()));
        }
        catch (IOException e) {
            return null;
        }
        return info;
    }

    public ISignatureCreationAlgorithm getSignatureAlgorithm() {
        try {
            MyDSASignature algorithm = new MyDSASignature();
            algorithm.initSign(this);
            return algorithm;
        }
        catch (InvalidKeyException invalidKeyException) {
            return null;
        }
    }

    public DSAParams getParams() {
        return this.m_params;
    }

    public MyDSAParams getMyDSAParams() {
        return this.m_params;
    }

    public DSAPrivateKeyParameters getPrivateParams() {
        return new DSAPrivateKeyParameters(this.m_X, (DSAParameters)this.m_params);
    }

    public Element toXmlElement(Document a_doc) {
        Element elemPrivKey = a_doc.createElement(XML_ELEMENT_NAME);
        Element elem = a_doc.createElement("G");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_params.getG().toByteArray()));
        elem = a_doc.createElement("P");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_params.getP().toByteArray()));
        elem = a_doc.createElement("Q");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_params.getQ().toByteArray()));
        elem = a_doc.createElement("X");
        elemPrivKey.appendChild(elem);
        XMLUtil.setValue((Node)elem, Base64.encodeBytes(this.m_X.toByteArray()));
        return elemPrivKey;
    }
}

