/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.terms.TCComponent;
import anon.terms.TCComposite;
import anon.terms.TermsAndConditions;
import anon.terms.template.Paragraph;
import anon.terms.template.Section;
import anon.terms.template.TermsAndConditionsTemplate;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.MixConfigTextField;
import gui.TermsAndConditionsDialog;
import gui.TitledGridBagPanel;
import gui.dialog.DialogContentPane;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.plaf.basic.BasicComboBoxRenderer;
import javax.swing.text.JTextComponent;
import mixconfig.panels.TermsAndConditionsPanel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TermsAndConditionsContentDialog
extends JAPDialog
implements ItemListener,
ActionListener,
FocusListener {
    static final String MSG_STATUS_PREFIX = TermsAndConditionsContentDialog.class.getName() + "_status";
    static final String MSG_NAME = TermsAndConditionsContentDialog.class.getName() + "_name";
    static final String MSG_ID = TermsAndConditionsContentDialog.class.getName() + "_id";
    static final String MSG_ID_DESCRIPTION = TermsAndConditionsContentDialog.class.getName() + "_idDescription";
    static final String MSG_BUTTON_FROM_TEMPLATE = TermsAndConditionsContentDialog.class.getName() + "_btnFromTemplate";
    static final String MSG_BUTTON_CAPITALIZE = TermsAndConditionsContentDialog.class.getName() + "_btnCapitalize";
    static final String MSG_BUTTON_BOLD = TermsAndConditionsContentDialog.class.getName() + "_btnBold";
    static final String MSG_BUTTON_URL_TAG = TermsAndConditionsContentDialog.class.getName() + "_btnUrlTag";
    static final String URL_TAG = "<Url></Url>";
    private TermsAndConditionsPanel parentPanel;
    private JButton sectionAddButton;
    private JButton sectionDeleteButton;
    private JButton sectionResetButton;
    private JButton paragraphAddButton;
    private JButton paragraphDeleteButton;
    private JButton paragraphResetButton;
    private JButton fromTemplateButton;
    private JButton capitalizeButton;
    private JButton boldButton;
    private JButton urlTagButton;
    private JButton previewButton;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox sectionChoice;
    private JComboBox paragraphChoice;
    private JTextField sectionNameTemplate;
    private JTextArea templateText;
    private JTextField sectionNameTranslation;
    private JTextArea translationText;
    private TitledGridBagPanel sectionPanel;
    private TitledGridBagPanel paragraphPanel;
    private TitledGridBagPanel templateContentPanel;
    private TitledGridBagPanel customizedContentPanel;
    private TCComposite templateSections = null;
    private TCComposite translationSections = null;
    private int lastCaretPosition = 0;

    private TermsAndConditionsContentDialog(TermsAndConditionsPanel parentPanel, TermsAndConditionsTemplate template, TermsAndConditions.Translation translation) {
        super(parentPanel, JAPMessages.getString(TermsAndConditionsPanel.MSG_CONTENT), true);
        this.parentPanel = parentPanel;
        this.setDefaultCloseOperation(2);
        this.initializeComponents();
        this.placeComponents();
        this.templateSections = template.getSections();
        this.translationSections = translation.getSections();
        this.loadSectionList();
    }

    private void initializeComponents() {
        this.sectionAddButton = GUIUtils.createButton("bttnAdd");
        this.sectionDeleteButton = GUIUtils.createButton("bttnDelete");
        this.sectionResetButton = new JButton(JAPMessages.getString(TermsAndConditionsPanel.MSG_RESET));
        this.paragraphAddButton = GUIUtils.createButton("bttnAdd");
        this.paragraphDeleteButton = GUIUtils.createButton("bttnDelete");
        this.paragraphResetButton = new JButton(JAPMessages.getString(TermsAndConditionsPanel.MSG_RESET));
        JPanel contentActionButtonPanel = new JPanel();
        this.fromTemplateButton = new JButton(JAPMessages.getString(MSG_BUTTON_FROM_TEMPLATE));
        this.capitalizeButton = new JButton(JAPMessages.getString(MSG_BUTTON_CAPITALIZE));
        this.boldButton = new JButton(JAPMessages.getString(MSG_BUTTON_BOLD));
        this.urlTagButton = new JButton(JAPMessages.getString(MSG_BUTTON_URL_TAG));
        contentActionButtonPanel.add(this.fromTemplateButton);
        contentActionButtonPanel.add(this.capitalizeButton);
        contentActionButtonPanel.add(this.boldButton);
        contentActionButtonPanel.add(this.urlTagButton);
        this.previewButton = new JButton(JAPMessages.getString(TermsAndConditionsPanel.MSG_PREVIEW));
        this.okButton = new JButton(JAPMessages.getString(DialogContentPane.MSG_OK));
        this.cancelButton = new JButton(JAPMessages.getString(DialogContentPane.MSG_CANCEL));
        this.sectionChoice = new JComboBox();
        this.paragraphChoice = new JComboBox();
        this.sectionNameTemplate = new MixConfigTextField(20);
        this.templateText = new JTextArea(7, 50);
        this.sectionNameTranslation = new MixConfigTextField(20);
        this.translationText = new JTextArea(7, 50);
        this.sectionPanel = TermsAndConditionsContentDialog.createTCComponentPanel(TermsAndConditionsPanel.MSG_SECTION, this.sectionChoice, this.sectionAddButton, this.sectionDeleteButton, this.sectionResetButton);
        this.paragraphPanel = TermsAndConditionsContentDialog.createTCComponentPanel(TermsAndConditionsPanel.MSG_PARAGRAPH, this.paragraphChoice, this.paragraphAddButton, this.paragraphDeleteButton, this.paragraphResetButton);
        this.templateContentPanel = TermsAndConditionsContentDialog.createContentPanel(TermsAndConditionsPanel.MSG_TEMPLATE_LABEL, this.sectionNameTemplate, this.templateText, null);
        this.customizedContentPanel = TermsAndConditionsContentDialog.createContentPanel(TermsAndConditionsPanel.MSG_TRANSLATION_LABEL, this.sectionNameTranslation, this.translationText, contentActionButtonPanel);
        this.sectionChoice.addItemListener(this);
        this.paragraphChoice.addItemListener(this);
        this.sectionAddButton.addActionListener(this);
        this.sectionDeleteButton.addActionListener(this);
        this.sectionResetButton.addActionListener(this);
        this.paragraphAddButton.addActionListener(this);
        this.paragraphDeleteButton.addActionListener(this);
        this.paragraphResetButton.addActionListener(this);
        this.fromTemplateButton.addActionListener(this);
        this.capitalizeButton.addActionListener(this);
        this.boldButton.addActionListener(this);
        this.urlTagButton.addActionListener(this);
        this.previewButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.sectionNameTranslation.addFocusListener(this);
        this.translationText.addFocusListener(this);
        this.sectionNameTemplate.setEditable(false);
        this.templateText.setEditable(false);
        this.templateText.setLineWrap(true);
        this.translationText.setLineWrap(true);
        TCComponentListItemRenderer tcComponentRenderer = new TCComponentListItemRenderer();
        this.sectionChoice.setRenderer(tcComponentRenderer);
        this.paragraphChoice.setRenderer(tcComponentRenderer);
    }

    private void placeComponents() {
        Container contentPane = this.getContentPane();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        contentPane.setLayout(gridbag);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.previewButton);
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(this.okButton);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 0;
        c.gridy = 0;
        c.insets = new Insets(3, 3, 3, 3);
        c.anchor = 17;
        c.fill = 1;
        contentPane.add((Component)this.sectionPanel, c);
        c.gridx = 1;
        contentPane.add((Component)this.paragraphPanel, c);
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 1;
        contentPane.add((Component)this.templateContentPanel, c);
        c.gridy = 2;
        contentPane.add((Component)this.customizedContentPanel, c);
        c.gridy = 3;
        contentPane.add((Component)buttonPanel, c);
    }

    public void loadSectionList() {
        this.loadSectionList(null);
    }

    public void loadSectionList(TCComponent selected) {
        this.sectionChoice.removeAllItems();
        TCComponent[] fromTemplate = this.templateSections != null ? this.templateSections.getTCComponents() : null;
        TCComponent[] fromTrans = this.translationSections != null ? this.translationSections.getTCComponents() : null;
        Collection items = TCComponentListItem.createList(fromTemplate, fromTrans);
        this.loadComboBoxItems(this.sectionChoice, items, selected);
    }

    public void loadParagraphList() {
        this.loadParagraphList(null);
    }

    public void loadParagraphList(TCComponent selected) {
        this.paragraphChoice.removeAllItems();
        Collection items = TCComponentListItem.createList(this.getParagraphsOfSelectedTemplateSection(), this.getParagraphsOfSelectedTranslationSection());
        this.loadComboBoxItems(this.paragraphChoice, items, selected);
    }

    private void loadComboBoxItems(JComboBox comboBox, Collection<TCComponentListItem> items, TCComponent selected) {
        TCComponentListItem selectedItem = null;
        TCComponent currentComponent = null;
        for (TCComponentListItem item : items) {
            if (selected != null) {
                currentComponent = item.getTranslationComponent();
                if (currentComponent == null) {
                    currentComponent = item.getTemplateComponent();
                }
                if (currentComponent.getId() == selected.getId()) {
                    selectedItem = item;
                }
            }
            comboBox.addItem(item);
        }
        if (selectedItem != null) {
            comboBox.setSelectedItem(selectedItem);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            if (e.getSource() == this.sectionChoice) {
                this.loadParagraphList();
            }
            Section templateSect = this.getSelectedTemplateSection();
            Section transSect = this.getSelectedTranslationSection();
            Paragraph templatePar = this.getSelectedTemplateParagraph();
            Paragraph transPar = this.getSelectedTranslationParagraph();
            this.templateText.setText(templatePar != null ? templatePar.toString() : "");
            this.translationText.setText(transPar != null ? transPar.toString() : "");
            this.sectionNameTemplate.setText(templateSect != null && templateSect.hasContent() && templateSect.getContent() != null ? templateSect.getContent().toString().trim() : "");
            this.sectionNameTranslation.setText(transSect != null && transSect.hasContent() && transSect.getContent() != null ? transSect.getContent().toString().trim() : "");
            this.lastCaretPosition = 0;
            this.enableComponents();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.sectionAddButton) {
            this.actionAddSection();
        } else if (e.getSource() == this.sectionDeleteButton) {
            this.actionDeleteSection();
        } else if (e.getSource() == this.sectionResetButton) {
            this.actionResetSection();
        } else if (e.getSource() == this.paragraphAddButton) {
            this.actionAddParagraph();
        } else if (e.getSource() == this.paragraphDeleteButton) {
            this.actionDeleteParagraph();
        } else if (e.getSource() == this.paragraphResetButton) {
            this.actionResetParagraph();
        } else if (e.getSource() == this.fromTemplateButton) {
            this.actionContentFromTemplate();
        } else if (e.getSource() == this.capitalizeButton) {
            this.actionCapitalizeContent();
        } else if (e.getSource() == this.boldButton) {
            this.actionSetContentBold();
        } else if (e.getSource() == this.urlTagButton) {
            this.actionAddUrlTag();
        } else if (e.getSource() == this.previewButton) {
            this.actionPreview();
        } else {
            if (e.getSource() == this.okButton) {
                this.dispose();
                return;
            }
            if (e.getSource() == this.cancelButton) {
                this.translationSections = null;
                this.dispose();
                return;
            }
        }
        this.enableComponents();
    }

    private Section getSelectedTemplateSection() {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice);
        return (Section)(item != null ? item.getTemplateComponent() : null);
    }

    private Section getSelectedTranslationSection() {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice);
        return (Section)(item != null ? item.getTranslationComponent() : null);
    }

    private TCComponent[] getParagraphsOfSelectedTemplateSection() {
        Section selectedTemplateSection = this.getSelectedTemplateSection();
        return selectedTemplateSection != null ? selectedTemplateSection.getTCComponents() : null;
    }

    private TCComponent[] getParagraphsOfSelectedTranslationSection() {
        Section selectedTranslationSection = this.getSelectedTranslationSection();
        return selectedTranslationSection != null ? selectedTranslationSection.getTCComponents() : null;
    }

    private Paragraph getSelectedTemplateParagraph() {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice);
        return (Paragraph)(item != null ? item.getTemplateComponent() : null);
    }

    private Paragraph getSelectedTranslationParagraph() {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice);
        return (Paragraph)(item != null ? item.getTranslationComponent() : null);
    }

    private Section getCustomizedSection(boolean withSectionName) {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice);
        Section customizedSection = (Section)item.getTranslationComponent();
        if (customizedSection == null) {
            Section templateSection = (Section)item.getTemplateComponent();
            customizedSection = new Section(templateSection.getId(), withSectionName ? templateSection.getContent() : null);
            this.translationSections.addTCComponent(customizedSection);
            item.setTranslationComponent(customizedSection);
        }
        return customizedSection;
    }

    private Section getCustomizedSection() {
        return this.getCustomizedSection(false);
    }

    private Paragraph getCustomizedParagraph(boolean withSectionName) {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice);
        Paragraph customizedParagraph = (Paragraph)item.getTranslationComponent();
        if (customizedParagraph == null) {
            Paragraph templateParagraph = (Paragraph)item.getTemplateComponent();
            customizedParagraph = new Paragraph(templateParagraph.getId());
            Section customizedSection = this.getCustomizedSection(withSectionName);
            customizedSection.addTCComponent(customizedParagraph);
        }
        return customizedParagraph;
    }

    private Paragraph getCustomizedParagraph() {
        return this.getCustomizedParagraph(false);
    }

    private static TCComponentListItem getSelectedListItem(JComboBox comboBox) {
        Object item = comboBox.getSelectedItem();
        return (TCComponentListItem)(item instanceof TCComponentListItem ? item : null);
    }

    private static TitledGridBagPanel createTCComponentPanel(String nameKey, JComboBox choiceBox, JButton addButton, JButton deleteButton, JButton resetButton) {
        TitledGridBagPanel tcPanel = new TitledGridBagPanel(JAPMessages.getString(nameKey));
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(addButton);
        buttonPanel.add(deleteButton);
        buttonPanel.add(resetButton);
        tcPanel.addRow(new Component[]{choiceBox}, new int[]{0});
        tcPanel.addRow(new Component[]{buttonPanel}, new int[]{0});
        return tcPanel;
    }

    private static TitledGridBagPanel createContentPanel(String contentSourceNameKey, JTextField sectionNameTF, JTextArea paragraphTextArea, JPanel buttonPanel) {
        TitledGridBagPanel contentPanel = new TitledGridBagPanel(JAPMessages.getString(TermsAndConditionsPanel.MSG_CONTENT) + "/" + JAPMessages.getString(contentSourceNameKey));
        contentPanel.addRow(new Component[]{GUIUtils.createLabel(TermsAndConditionsPanel.MSG_SECTION), sectionNameTF}, new int[]{1, 0});
        contentPanel.addRow(new Component[]{GUIUtils.createLabel(TermsAndConditionsPanel.MSG_PARAGRAPH), new JScrollPane(paragraphTextArea, 22, 30)}, new int[]{1, 0});
        if (buttonPanel != null) {
            contentPanel.addRow(buttonPanel);
        }
        return contentPanel;
    }

    private void actionAddSection() {
        Section newSection = AddComponentDialog.showAddSectionDialog(this.getContentPane());
        if (newSection != null) {
            TCComponent existingSection = this.translationSections.getTCComponent(newSection.getId());
            if (existingSection != null && existingSection.hasContent()) {
                JAPDialog.showErrorDialog(this.getParentComponent(), "Section '" + existingSection.getContent() + "' with id " + existingSection.getId() + " already exists");
            } else {
                this.translationSections.addTCComponent(newSection);
                this.loadSectionList(newSection);
            }
        }
    }

    private void actionAddParagraph() {
        Paragraph newParagraph = AddComponentDialog.showAddParagraphDialog(this.getContentPane());
        if (newParagraph != null) {
            Section translationSection = this.getCustomizedSection();
            TCComponent existingParagraph = translationSection.getTCComponent(newParagraph.getId());
            if (existingParagraph != null && existingParagraph.hasContent()) {
                JAPDialog.showErrorDialog(this.getParentComponent(), "Paragraph with id " + existingParagraph.getId() + " already exists");
            } else {
                Section templateSection = this.getSelectedTemplateSection();
                if (templateSection != null && (existingParagraph = templateSection.getTCComponent(newParagraph.getId())) != null) {
                    newParagraph.setContent(existingParagraph.getContent());
                }
                translationSection.addTCComponent(newParagraph);
                this.loadParagraphList(newParagraph);
            }
        }
    }

    private void actionDeleteSection() {
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice);
        this.deleteSelectedComponent(item, this.translationSections);
        this.loadSectionList(item.getTemplateComponent());
    }

    private void actionDeleteParagraph() {
        boolean containerHadContent;
        TCComponentListItem item = TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice);
        Section container = this.getSelectedTranslationSection();
        boolean bl = containerHadContent = container != null && container.hasContent();
        if (container == null) {
            container = this.getCustomizedSection();
        }
        this.deleteSelectedComponent(item, container);
        if (containerHadContent && !container.hasContent()) {
            this.translationSections.removeTCComponent(container.getId());
            this.loadSectionList(this.getSelectedTemplateSection());
        } else {
            this.loadParagraphList(item.getTemplateComponent());
        }
    }

    private void actionContentFromTemplate() {
        Paragraph templateParagraph = this.getSelectedTemplateParagraph();
        Paragraph customizedParagraph = this.getSelectedTranslationParagraph();
        if (templateParagraph != null) {
            if (customizedParagraph == null) {
                customizedParagraph = this.getCustomizedParagraph();
            }
            if (templateParagraph.hasContent()) {
                customizedParagraph.setContent(templateParagraph.getContent());
            }
            this.loadParagraphList(customizedParagraph);
        }
    }

    private void actionCapitalizeContent() {
        Paragraph p = this.getSelectedTranslationParagraph();
        if (p != null) {
            this.capitalizeTextContent(p);
            this.translationText.setText(p.toString());
        }
    }

    private void actionSetContentBold() {
        Paragraph p = this.getSelectedTranslationParagraph();
        if (p != null) {
            p.setContentBold();
            this.translationText.setText(p.toString());
        }
    }

    private void actionAddUrlTag() {
        String text = this.translationText.getText();
        if (text == null || text.equals("")) {
            this.editParagraph(URL_TAG);
        } else {
            StringBuffer buffer = new StringBuffer(text);
            buffer.insert(this.lastCaretPosition, URL_TAG);
            this.editParagraph(buffer.toString());
        }
    }

    private void capitalizeTextContent(Paragraph p) {
        NodeList contentNodes = (NodeList)p.getContent();
        for (int i = 0; i < contentNodes.getLength(); ++i) {
            this.capitalizeTextContentRecursion(contentNodes.item(i));
        }
    }

    private void capitalizeTextContentRecursion(Node node) {
        if (node != null) {
            if (node.getNodeType() == 3) {
                node.setTextContent(node.getTextContent().toUpperCase());
            } else if (node.getNodeType() == 1) {
                NodeList nl = ((Element)node).getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    this.capitalizeTextContentRecursion(nl.item(i));
                }
            } else if (node.getNodeType() == 9) {
                this.capitalizeTextContentRecursion(((Document)node).getDocumentElement());
            }
        }
    }

    private void deleteSelectedComponent(TCComponentListItem item, TCComposite container) {
        if (item != null && item.getStatus() != null && !item.getStatus().equals("Deleted") && container != null) {
            TCComponent deleteComponent = item.getTranslationComponent();
            if (deleteComponent != null) {
                container.removeTCComponent(deleteComponent.getId());
            } else {
                try {
                    TCComponent templateComponent = item.getTemplateComponent();
                    deleteComponent = (TCComponent)templateComponent.getClass().newInstance();
                    deleteComponent.setId(templateComponent.getId());
                    deleteComponent.setContent(null);
                    container.addTCComponent(deleteComponent);
                }
                catch (InstantiationException e) {
                }
                catch (IllegalAccessException e) {
                    // empty catch block
                }
            }
        }
    }

    private void actionResetSection() {
        TCComponentListItem sectionItem = TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice);
        this.resetCustomizedComponent(sectionItem, this.translationSections);
        this.loadSectionList(sectionItem.getTemplateComponent());
    }

    private void actionResetParagraph() {
        TCComponentListItem paragraphItem = TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice);
        Section container = this.getSelectedTranslationSection();
        boolean containerHadContent = container != null && container.hasContent();
        this.resetCustomizedComponent(paragraphItem, container);
        if (containerHadContent && !container.hasContent()) {
            this.translationSections.removeTCComponent(container.getId());
            this.loadSectionList(this.getSelectedTemplateSection());
        } else {
            this.loadParagraphList(paragraphItem.getTemplateComponent());
        }
    }

    private void actionPreview() {
        TermsAndConditions.Translation previewTranslation = this.parentPanel.getPreviewTranslation();
        if (previewTranslation != null) {
            previewTranslation.setSections(this.translationSections);
            TermsAndConditionsDialog.previewTranslation(this.getContentPane(), previewTranslation);
        }
    }

    private void resetCustomizedComponent(TCComponentListItem item, TCComposite container) {
        TCComponent translationComponent;
        String status;
        if (item != null && container != null && (status = item.getStatus()) != null && (translationComponent = item.getTranslationComponent()) != null) {
            container.removeTCComponent(translationComponent.getId());
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.lastCaretPosition = this.translationText.getCaretPosition();
    }

    @Override
    public void focusLost(FocusEvent e) {
        String content;
        JTextComponent source = (JTextComponent)e.getSource();
        String string = content = source.getText() != null ? source.getText() : "";
        if (source == this.translationText) {
            this.editParagraph(content);
        } else if (source == this.sectionNameTranslation) {
            this.editSection(content);
        }
        this.enableComponents();
    }

    private void editSection(String content) {
        Section translationSection = this.getSelectedTranslationSection();
        if (translationSection != null) {
            if (content != null && !content.equals("")) {
                translationSection.setContent(content);
            } else if (translationSection.getTCComponentCount() == 0) {
                this.actionResetSection();
            }
        } else if (content != null && !content.equals("")) {
            translationSection = this.getCustomizedSection(true);
            translationSection.setContent(content);
            this.loadSectionList(translationSection);
        }
    }

    private void editParagraph(String content) {
        if (this.getSelectedTranslationParagraph() != null && (content == null || content.equals(""))) {
            this.actionResetParagraph();
        } else if (content != null && !content.equals("")) {
            int caretSave = this.lastCaretPosition;
            Paragraph customizedParagraph = this.getCustomizedParagraph();
            customizedParagraph.setContent(content);
            this.loadParagraphList(customizedParagraph);
            this.lastCaretPosition = caretSave;
        }
    }

    protected void enableComponents() {
        this.sectionChoice.setEnabled(this.isSectionSelectable());
        this.sectionDeleteButton.setEnabled(this.isSectionDeletable());
        this.sectionResetButton.setEnabled(this.isSectionResettable());
        this.paragraphChoice.setEnabled(this.isParagraphSelectable());
        this.paragraphAddButton.setEnabled(this.isParagraphAddable());
        this.paragraphDeleteButton.setEnabled(this.isParagraphDeletable());
        this.paragraphResetButton.setEnabled(this.isParagraphResettable());
        this.fromTemplateButton.setEnabled(this.isContentFromTemplateAvailable());
        this.capitalizeButton.setEnabled(this.isContentCapitalizable());
        this.boldButton.setEnabled(this.isContentSetToBoldPossible());
        this.previewButton.setEnabled(this.parentPanel.isPreviewPossible());
        this.translationText.setEnabled(this.isParagraphEditable());
        this.sectionNameTranslation.setEnabled(this.isSectionNameEditable());
    }

    private boolean isSectionSelectable() {
        return TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice) != null;
    }

    private boolean isSectionResettable() {
        return this.isSectionSelectable() && this.getSelectedTranslationSection() != null;
    }

    private boolean isSectionDeletable() {
        return this.isSectionSelectable() && this.isItemDeletable(TermsAndConditionsContentDialog.getSelectedListItem(this.sectionChoice));
    }

    private boolean isParagraphSelectable() {
        return this.isSectionDeletable() && TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice) != null;
    }

    private boolean isParagraphDeletable() {
        return this.isParagraphSelectable() && this.isItemDeletable(TermsAndConditionsContentDialog.getSelectedListItem(this.paragraphChoice));
    }

    private boolean isParagraphResettable() {
        return this.isParagraphSelectable() && this.getSelectedTranslationParagraph() != null;
    }

    private boolean isParagraphEditable() {
        return this.isParagraphDeletable();
    }

    private boolean isContentCapitalizable() {
        Paragraph customizedPar = this.getSelectedTranslationParagraph();
        return customizedPar != null && customizedPar.hasContent();
    }

    private boolean isContentSetToBoldPossible() {
        Paragraph customizedPar = this.getSelectedTranslationParagraph();
        return customizedPar != null && customizedPar.hasContent();
    }

    private boolean isContentFromTemplateAvailable() {
        Paragraph templatePar = this.getSelectedTemplateParagraph();
        return templatePar != null && templatePar.hasContent();
    }

    private boolean isParagraphAddable() {
        return this.isSectionDeletable();
    }

    private boolean isSectionNameEditable() {
        return this.isSectionDeletable();
    }

    private boolean isItemDeletable(TCComponentListItem item) {
        return item != null && item.getStatus() != null && !item.getStatus().equals("Deleted");
    }

    public static TCComposite showContentDialog(TermsAndConditionsPanel parentPanel, TermsAndConditionsTemplate template, TermsAndConditions.Translation translation) {
        TermsAndConditionsContentDialog dialog = new TermsAndConditionsContentDialog(parentPanel, template, translation);
        dialog.pack();
        dialog.setVisible(true);
        return dialog.translationSections;
    }

    public static class TCComponentListItemRenderer
    extends BasicComboBoxRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof TCComponentListItem && value != null && c instanceof JLabel && c != null) {
                TCComponentListItem item = (TCComponentListItem)value;
                JLabel itemLabel = (JLabel)c;
                if (item.getStatus() != null && item.getStatus().equals("Deleted")) {
                    Font f = itemLabel.getFont();
                    itemLabel.setFont(f.deriveFont(2));
                }
            }
            return c;
        }
    }

    private static class AddComponentDialog
    extends JAPDialog
    implements KeyListener,
    ActionListener {
        JButton ok = new JButton(JAPMessages.getString(DialogContentPane.MSG_OK));
        JButton cancel = new JButton(JAPMessages.getString(DialogContentPane.MSG_CANCEL));
        JTextField[] inputFields = null;
        InputVerifier verifier = null;

        private AddComponentDialog(Component parent, String componentKey, JTextField[] inputFields, JLabel[] labels, JLabel helpTextLabel, InputVerifier verifier) {
            super(parent, JAPMessages.getString(componentKey), true);
            this.inputFields = inputFields;
            this.verifier = verifier;
            this.setDefaultCloseOperation(1);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.gridheight = 1;
            c.gridwidth = 1;
            c.insets = new Insets(3, 3, 3, 3);
            c.anchor = 17;
            c.fill = 1;
            c.gridx = 0;
            c.gridy = 0;
            while (c.gridy < labels.length) {
                this.getContentPane().add((Component)labels[c.gridy], c);
                ++c.gridy;
            }
            c.gridx = 1;
            c.gridwidth = 0;
            c.gridy = 0;
            while (c.gridy < this.inputFields.length) {
                if (verifier != null) {
                    this.inputFields[c.gridy].addKeyListener(this);
                }
                this.getContentPane().add((Component)this.inputFields[c.gridy], c);
                ++c.gridy;
            }
            this.ok.addActionListener(this);
            this.cancel.addActionListener(this);
            JPanel panel = new JPanel();
            panel.add(this.ok);
            panel.add(this.cancel);
            c.gridx = 0;
            c.gridy = Math.max(inputFields.length, labels.length);
            if (helpTextLabel != null) {
                this.getContentPane().add((Component)helpTextLabel, c);
                ++c.gridy;
            }
            this.getContentPane().add((Component)panel, c);
            this.ok.setEnabled(verifier != null ? verifier.verfifyInput() : true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == this.cancel) {
                for (int i = 0; i < this.inputFields.length; ++i) {
                    this.inputFields[i].setText("");
                }
            }
            this.setVisible(false);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.ok.setEnabled(this.verifier != null ? this.verifier.verfifyInput() : true);
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
        }

        public static boolean verifyValidID(String input) {
            if (input != null) {
                try {
                    Double.parseDouble(input);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        }

        public static boolean verifyValidName(String input) {
            return input != null && !input.equals("");
        }

        public static Section showAddSectionDialog(Component parent) {
            JLabel idLabel = GUIUtils.createLabel(MSG_ID);
            JLabel nameLabel = GUIUtils.createLabel(MSG_NAME);
            final JTextField idField = new JTextField(10);
            final JTextField nameField = new JTextField(10);
            InputVerifier verifier = new InputVerifier(){

                @Override
                public boolean verfifyInput() {
                    return AddComponentDialog.verifyValidID(idField.getText()) && AddComponentDialog.verifyValidName(nameField.getText());
                }
            };
            AddComponentDialog addSectionDialog = new AddComponentDialog(parent, TermsAndConditionsPanel.MSG_SECTION, new JTextField[]{idField, nameField}, new JLabel[]{idLabel, nameLabel}, GUIUtils.createMultiLineLabel(MSG_ID_DESCRIPTION, 300), verifier);
            addSectionDialog.pack();
            addSectionDialog.setVisible(true);
            Section sect = null;
            double id = -1.0;
            String name = "";
            try {
                id = idField.getText() != null ? Double.parseDouble(idField.getText()) : -1.0;
                name = nameField.getText() != null ? nameField.getText() : "";
                sect = id >= 0.0 && !name.equals("") ? new Section(id, name) : null;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            addSectionDialog.dispose();
            return sect;
        }

        public static Paragraph showAddParagraphDialog(Component parent) {
            JLabel idLabel = GUIUtils.createLabel(MSG_ID);
            final JTextField idField = new JTextField(10);
            InputVerifier verifier = new InputVerifier(){

                @Override
                public boolean verfifyInput() {
                    return AddComponentDialog.verifyValidID(idField.getText());
                }
            };
            AddComponentDialog addParagraphDialog = new AddComponentDialog(parent, TermsAndConditionsPanel.MSG_SECTION, new JTextField[]{idField}, new JLabel[]{idLabel}, GUIUtils.createMultiLineLabel(MSG_ID_DESCRIPTION, 300), verifier);
            addParagraphDialog.pack();
            addParagraphDialog.setVisible(true);
            Paragraph par = null;
            double id = -1.0;
            try {
                id = idField.getText() != null ? Double.parseDouble(idField.getText()) : -1.0;
                par = id >= 0.0 ? new Paragraph(id) : null;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            addParagraphDialog.dispose();
            return par;
        }

        private static interface InputVerifier {
            public boolean verfifyInput();
        }
    }

    private static class TCComponentListItem {
        public static final String STATUS_EDITED = "Edited";
        public static final String STATUS_DELETED = "Deleted";
        public static final String STATUS_NEW = "New";
        double id = 0.0;
        TCComponent templateComponent = null;
        TCComponent translationComponent = null;

        public TCComponentListItem() {
        }

        public TCComponentListItem(TCComponent templateComponent, TCComponent translationComponentType) {
            this.templateComponent = templateComponent;
            this.translationComponent = translationComponentType;
        }

        public TCComponent getTemplateComponent() {
            return this.templateComponent;
        }

        public void setTemplateComponent(TCComponent templateComponent) {
            this.templateComponent = templateComponent;
        }

        public TCComponent getTranslationComponent() {
            return this.translationComponent;
        }

        public void setTranslationComponent(TCComponent translationComponent) {
            this.translationComponent = translationComponent;
        }

        private String getStatus() {
            if (this.templateComponent == null) {
                if (this.translationComponent != null) {
                    return STATUS_NEW;
                }
                return null;
            }
            if (this.translationComponent != null) {
                return this.translationComponent.hasContent() ? STATUS_EDITED : STATUS_DELETED;
            }
            return "";
        }

        private String getStatusDisplayString() {
            String status = this.getStatus();
            return status != null && !status.equals("") ? JAPMessages.getString(MSG_STATUS_PREFIX + status) : status;
        }

        private String getTypeString() {
            if (this.templateComponent == null && this.translationComponent == null) {
                return null;
            }
            Class<?> tcComponentClass = this.templateComponent != null ? this.templateComponent.getClass() : this.translationComponent.getClass();
            return JAPMessages.getString(TermsAndConditionsPanel.class.getName() + "_" + tcComponentClass.getSimpleName().toLowerCase());
        }

        private String getIdString() {
            if (this.templateComponent == null && this.translationComponent == null) {
                return null;
            }
            return "" + (this.templateComponent != null ? this.templateComponent.getId() : this.translationComponent.getId());
        }

        public String toString() {
            String typeString = this.getTypeString();
            String idString = this.getIdString();
            String statusDisplayString = this.getStatusDisplayString();
            if (statusDisplayString != null && !statusDisplayString.equals("")) {
                statusDisplayString = "(" + statusDisplayString + ")";
            }
            if (typeString != null && idString != null && statusDisplayString != null) {
                return typeString + " " + idString + " " + statusDisplayString;
            }
            return null;
        }

        private static Collection<TCComponentListItem> createList(TCComponent[] fromTemplate, TCComponent[] fromTrans) {
            int i;
            TreeMap<Double, TCComponentListItem> ht = new TreeMap<Double, TCComponentListItem>();
            TCComponentListItem currentItem = null;
            if (fromTemplate != null) {
                for (i = 0; i < fromTemplate.length; ++i) {
                    ht.put(fromTemplate[i].getId(), new TCComponentListItem(fromTemplate[i], null));
                }
            }
            if (fromTrans != null) {
                for (i = 0; i < fromTrans.length; ++i) {
                    currentItem = (TCComponentListItem)ht.get(fromTrans[i].getId());
                    if (currentItem == null) {
                        currentItem = new TCComponentListItem(null, fromTrans[i]);
                        ht.put(fromTrans[i].getId(), currentItem);
                        continue;
                    }
                    currentItem.setTranslationComponent(fromTrans[i]);
                }
            }
            return ht.values();
        }
    }
}

