/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.ITrustModel;
import anon.client.TrustException;
import anon.crypto.SignatureVerifier;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.util.JAPMessages;
import java.security.SignatureException;
import java.util.Date;
import java.util.Observable;

public class BasicTrustModel
extends Observable
implements ITrustModel {
    public void checkTrust(MixCascade mixCascade) throws TrustException, SignatureException {
        int n;
        int n2 = 0;
        SignatureException signatureException = null;
        if (mixCascade == null || !mixCascade.isUserDefined() && !mixCascade.isVerified()) {
            throw new SignatureException(JAPMessages.getString("invalidSignature"));
        }
        if (SignatureVerifier.getInstance().isCheckSignatures()) {
            signatureException = new SignatureException(JAPMessages.getString("invalidSignature"));
            for (n = 0; n < mixCascade.getNumberOfMixes(); ++n) {
                if (mixCascade.getMixInfo(n) == null || mixCascade.getMixInfo(n).getCertPath() == null || !mixCascade.getMixInfo(n).getCertPath().isValid(new Date()) || n != 0 && n != mixCascade.getNumberOfMixes() - 1) continue;
                signatureException = null;
                break;
            }
            if (signatureException != null) {
                throw signatureException;
            }
        }
        for (n = 0; n < mixCascade.getNumberOfMixes(); ++n) {
            MixInfo mixInfo = mixCascade.getMixInfo(n);
            if ((mixInfo != null || !SignatureVerifier.getInstance().isCheckSignatures()) && (mixInfo == null || mixInfo.isVerified())) continue;
            ++n2;
            if (signatureException != null) continue;
            signatureException = new SignatureException(JAPMessages.getString("invalidSignature") + " (Mix " + (n + 1) + ")");
        }
        if (signatureException != null) {
            if (n2 > 1 || mixCascade.getNumberOfOperatorsShown() == 1 || mixCascade.getNumberOfMixes() <= 1) {
                signatureException = new SignatureException(JAPMessages.getString("invalidSignature"));
            }
            throw signatureException;
        }
    }

    public final boolean isTrusted(MixCascade mixCascade) {
        if (mixCascade == null) {
            return false;
        }
        if (mixCascade != null && mixCascade.isShownAsTrusted()) {
            return true;
        }
        try {
            this.checkTrust(mixCascade);
            return true;
        }
        catch (TrustException trustException) {
            return false;
        }
        catch (SignatureException signatureException) {
            return false;
        }
    }

    public final boolean isTrusted(MixCascade mixCascade, StringBuffer stringBuffer) {
        if (mixCascade != null && mixCascade.isShownAsTrusted()) {
            return true;
        }
        try {
            this.checkTrust(mixCascade);
            return true;
        }
        catch (TrustException trustException) {
            stringBuffer.append(trustException.getMessage());
            return false;
        }
        catch (SignatureException signatureException) {
            stringBuffer.append(signatureException.getMessage());
            return false;
        }
    }
}

