/*
 * Decompiled with CFR 0.152.
 */
package anon.util;

import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.ListenerInterface;
import anon.util.JAPMessages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class Util {
    public static final String VERSION_FORMAT = "00.00.000";
    private static final String WHITESPACE_ENCODED = "%20";
    private static final String WHITESPACE = " ";
    public static final int MAX_FORMAT_BYTES = 0;
    public static final int MAX_FORMAT_KBYTES = 1;
    public static final int MAX_FORMAT_MBYTES = 2;
    public static final int MAX_FORMAT_GBYTES = 3;
    public static final int MAX_FORMAT_KBIT_PER_SEC = 0;
    public static final int MAX_FORMAT_MBIT_PER_SEC = 1;
    public static final int MAX_FORMAT_GBIT_PER_SEC = 2;
    public static final int MAX_FORMAT_ALL = 4;

    private Util() {
    }

    public static String cutString(String string, int n) {
        if (string != null && string.length() > n) {
            string = string.substring(0, n).trim();
        }
        return string;
    }

    public static String stripString(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        String string3 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            string3 = string3 + stringTokenizer.nextToken().trim();
        }
        return string3;
    }

    public static String normaliseString(String string, int n) {
        if (string.length() < n) {
            char[] cArray = new char[n - string.length()];
            for (int i = 0; i < cArray.length; ++i) {
                cArray[i] = 32;
            }
            string = string + new String(cArray);
        }
        return string;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static boolean arraysEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == null && byArray2 == null) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean arraysEqual(char[] cArray, char[] cArray2) {
        if (cArray == null && cArray2 == null) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        if (cArray.length != cArray2.length) {
            return false;
        }
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean arraysEqual(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        if (n3 <= 0) {
            return true;
        }
        if (byArray == null || byArray2 == null || n < 0 || n2 < 0) {
            return false;
        }
        if (n + n3 > byArray.length || n2 + n3 > byArray2.length) {
            return false;
        }
        for (int i = 0; i < n3; ++i) {
            if (byArray[n + i] == byArray2[n2 + i]) continue;
            return false;
        }
        return true;
    }

    public static Vector toVector(Object object) {
        Vector<Object> vector = new Vector<Object>();
        if (object != null) {
            vector.addElement(object);
        }
        return vector;
    }

    public static Object[] toArray(Object object) {
        Object[] objectArray = object != null ? new Object[]{object} : new Object[]{};
        return objectArray;
    }

    private static void swap(String[] stringArray, String[] stringArray2, int n, int n2) {
        String string = stringArray[n];
        stringArray[n] = stringArray[n2];
        stringArray[n2] = string;
        string = stringArray2[n];
        stringArray2[n] = stringArray2[n2];
        stringArray2[n2] = string;
    }

    public static Vector sortStrings(Vector vector) {
        int n;
        Vector vector2 = new Vector();
        String[] stringArray = new String[vector.size()];
        int[] nArray = new int[vector.size()];
        String[] stringArray2 = new String[2];
        for (n = 0; n < stringArray.length; ++n) {
            int n2;
            stringArray[n] = vector.elementAt(n).toString().toLowerCase();
            nArray[n] = n;
            boolean bl = false;
            for (n2 = 0; n2 < stringArray2.length && n2 < stringArray[n].length(); ++n2) {
                if (!Util.isUmlaut(stringArray[n].charAt(n2), stringArray2, n2)) continue;
                bl = true;
            }
            if (!bl) continue;
            String string = "";
            for (n2 = 0; n2 < stringArray2.length && n2 < stringArray[n].length(); ++n2) {
                string = stringArray2[n2] == null ? string + stringArray[n].charAt(n2) : string + stringArray2[n2];
            }
            if (n2 < stringArray[n].length()) {
                string = string + stringArray[n].substring(n2, stringArray[n].length());
            }
            stringArray[n] = string;
        }
        Util.bubbleSortStrings(vector, stringArray, nArray);
        for (n = 0; n < stringArray.length; ++n) {
            vector2.addElement(vector.elementAt(nArray[n]));
        }
        return vector2;
    }

    public static double parseDouble(String string) throws NumberFormatException {
        int n = 0;
        int n2 = 0;
        int n3 = 1;
        boolean bl = true;
        int n4 = 1;
        if (string == null) {
            throw new NumberFormatException("NULL cannot be parsed as float!");
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isDigit(c)) {
                if (bl) {
                    n = n * 10 + (c - 48);
                    continue;
                }
                n3 *= 10;
                n2 = n2 * 10 + (c - 48);
                continue;
            }
            if (bl && (c == '.' || c == ',') && string.length() > 1) {
                bl = false;
                continue;
            }
            if (c == '+') continue;
            if (c == '-' && i == 0) {
                n4 = -1;
                continue;
            }
            throw new NumberFormatException("No valid float value '" + string + "'!");
        }
        double d = ((double)n + (double)n2 / (double)n3) * (double)n4;
        return d;
    }

    public static void sort(String[] stringArray, String[] stringArray2) {
        Util.quicksort(stringArray, stringArray2, 0, stringArray.length - 1);
    }

    private static int divide(String[] stringArray, String[] stringArray2, int n, int n2) {
        int n3 = n;
        for (int i = n; i < n2; ++i) {
            if (stringArray[i].compareTo(stringArray[n2]) > 0) continue;
            Util.swap(stringArray, stringArray2, n3, i);
            ++n3;
        }
        Util.swap(stringArray, stringArray2, n3, n2);
        return n3;
    }

    private static void quicksort(String[] stringArray, String[] stringArray2, int n, int n2) {
        if (n2 > n) {
            int n3 = Util.divide(stringArray, stringArray2, n, n2);
            Util.quicksort(stringArray, stringArray2, n, n3 - 1);
            Util.quicksort(stringArray, stringArray2, n3 + 1, n2);
        }
    }

    public static void sort(Vector vector, Comparable comparable) {
        if (vector != null) {
            Util.quicksort(vector, 0, vector.size() - 1, comparable);
        }
    }

    private static int divide(Vector vector, int n, int n2, Comparable comparable) {
        int n3 = n;
        for (int i = n; i < n2; ++i) {
            if (comparable.compare(vector.elementAt(i), vector.elementAt(n2)) > 0) continue;
            Util.swap(vector, n3, i);
            ++n3;
        }
        Util.swap(vector, n3, n2);
        return n3;
    }

    private static void quicksort(Vector vector, int n, int n2, Comparable comparable) {
        if (n2 > n) {
            int n3 = Util.divide(vector, n, n2, comparable);
            Util.quicksort(vector, n, n3 - 1, comparable);
            Util.quicksort(vector, n3 + 1, n2, comparable);
        }
    }

    private static void swap(Vector vector, int n, int n2) {
        Object e = vector.elementAt(n);
        vector.setElementAt(vector.elementAt(n2), n);
        vector.setElementAt(e, n2);
    }

    private static void bubbleSortStrings(Vector vector, String[] stringArray, int[] nArray) {
        for (int i = 1; i <= vector.size(); ++i) {
            for (int j = vector.size() - 1; j > i; --j) {
                if (stringArray[j].compareTo(stringArray[j - 1]) >= 0) continue;
                String string = stringArray[j];
                int n = nArray[j];
                stringArray[j] = stringArray[j - 1];
                nArray[j] = nArray[j - 1];
                stringArray[j - 1] = string;
                nArray[j - 1] = n;
            }
        }
    }

    private static boolean isUmlaut(char c, String[] stringArray, int n) {
        switch (c) {
            case '\u00e4': {
                stringArray[n] = "ae";
                return true;
            }
            case '\u00f6': {
                stringArray[n] = "oe";
                return true;
            }
            case '\u00fc': {
                stringArray[n] = "ue";
                return true;
            }
        }
        stringArray[n] = null;
        return false;
    }

    public static long convertVersionStringToNumber(String string) throws NumberFormatException {
        if (string == null) {
            throw new NumberFormatException("Version string is null!");
        }
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        try {
            l = Long.parseLong(stringTokenizer.nextToken()) * 100000L + Long.parseLong(stringTokenizer.nextToken()) * 1000L + Long.parseLong(stringTokenizer.nextToken());
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new NumberFormatException("Version string is too short!");
        }
        return l;
    }

    public static String replaceAll(String string, String string2, String string3) {
        return Util.replaceAll(string, string2, string3, null);
    }

    public static String replaceAll(String string, String string2, String string3, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.indexOf(string2, 0);
        int n2 = 0;
        boolean bl = true;
        String string4 = null;
        while (n != -1) {
            bl = true;
            if (stringArray != null) {
                string4 = string.substring(n);
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!string4.startsWith(stringArray[i])) continue;
                    bl = false;
                    break;
                }
            }
            if (bl) {
                stringBuffer.append(string.substring(n2, n));
                stringBuffer.append(string3);
                n2 = n + string2.length();
            }
            n = string.indexOf(string2, bl ? n2 : n + string2.length());
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static String encodeWhiteSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = string.indexOf(WHITESPACE, 0);
        int n2 = 0;
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(WHITESPACE_ENCODED);
            n2 = n + WHITESPACE.length();
            n = string.indexOf(WHITESPACE, n + 1);
        }
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    public static void closeStream(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                LogHolder.log(3, LogType.FILE, exception);
            }
        }
    }

    public static void closeStream(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                LogHolder.log(3, LogType.FILE, exception);
            }
        }
    }

    public static void copyStream(InputStream inputStream, OutputStream outputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Input stream is null!");
        }
        if (outputStream == null) {
            throw new IOException("Output stream is null!");
        }
        byte[] byArray = new byte[2048];
        int n = -1;
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        inputStream.close();
        outputStream.flush();
        outputStream.close();
    }

    public static String getStaticFieldValue(Class clazz, String string) {
        String string2 = null;
        try {
            Field field = clazz.getField(string);
            string2 = (String)field.get(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    public static String colonizeSKI(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append(string.charAt(i));
            if ((i + 1) % 2 != 0 || i == string.length() - 1) continue;
            stringBuffer.append(":");
        }
        return stringBuffer.toString();
    }

    public static InfoServiceDBEntry[] createDefaultInfoServices(String[] stringArray, String[] stringArray2, int[][] nArray) throws Exception {
        InfoServiceDBEntry[] infoServiceDBEntryArray = new InfoServiceDBEntry[stringArray.length];
        for (int i = 0; i < infoServiceDBEntryArray.length; ++i) {
            Vector<ListenerInterface> vector = new Vector<ListenerInterface>(nArray[i].length);
            for (int j = 0; j < nArray[i].length; ++j) {
                vector.addElement(new ListenerInterface(stringArray2[i], nArray[i][j]));
            }
            infoServiceDBEntryArray[i] = new InfoServiceDBEntry(stringArray[i], stringArray[i], vector, false, true, 0L, 0L, false);
            infoServiceDBEntryArray[i].markAsBootstrap();
        }
        return infoServiceDBEntryArray;
    }

    public static String formatKbitPerSecValueWithUnit(long l) {
        return Util.formatKbitPerSecValueWithUnit(l, 4);
    }

    public static String formatKbitPerSecValueWithUnit(long l, int n) {
        return Util.formatKbitPerSecValueWithoutUnit(l, n) + WHITESPACE + Util.formatKbitPerSecValueOnlyUnit(l, n);
    }

    public static String formatKbitPerSecValueOnlyUnit(long l) {
        return Util.formatKbitPerSecValueOnlyUnit(l, 4);
    }

    public static String formatKbitPerSecValueOnlyUnit(long l, int n) {
        if (l < 1000L || n < 1) {
            return JAPMessages.getString("kbit/s");
        }
        if (l < 1000000L || n < 2) {
            return JAPMessages.getString("Mbit/s");
        }
        return JAPMessages.getString("Gbit/s");
    }

    public static String formatKbitPerSecValueWithoutUnit(long l) {
        return Util.formatKbitPerSecValueWithoutUnit(l, 4);
    }

    public static String formatKbitPerSecValueWithoutUnit(long l, int n) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(JAPMessages.getLocale());
        double d = l;
        if (l < 1000L || n < 1) {
            decimalFormat.applyPattern("#,####");
        } else if (l < 1000000L || n < 2) {
            d /= 1000.0;
            decimalFormat.applyPattern("#,##0.0");
        } else {
            d /= 1000000.0;
            decimalFormat.applyPattern("#,##0.0");
        }
        return decimalFormat.format(d);
    }

    public static String formatBytesValueWithUnit(long l) {
        return Util.formatBytesValueWithUnit(l, 4);
    }

    public static String formatBytesValueWithUnit(long l, int n) {
        return Util.formatBytesValueWithoutUnit(l, n) + WHITESPACE + Util.formatBytesValueOnlyUnit(l, n);
    }

    public static String formatBytesValueOnlyUnit(long l) {
        return Util.formatBytesValueOnlyUnit(l, 4);
    }

    public static String formatBytesValueOnlyUnit(long l, int n) {
        if (l < 1000L || n < 1) {
            return JAPMessages.getString("Byte");
        }
        if (l < 1000000L || n < 2) {
            return JAPMessages.getString("kByte");
        }
        if (l < 1000000000L || n < 3) {
            return JAPMessages.getString("MByte");
        }
        return JAPMessages.getString("GByte");
    }

    public static String formatBytesValueWithoutUnit(long l) {
        return Util.formatBytesValueWithoutUnit(l, 4);
    }

    public static String formatBytesValueWithoutUnit(long l, int n) {
        DecimalFormat decimalFormat = (DecimalFormat)NumberFormat.getInstance(JAPMessages.getLocale());
        double d = l;
        if (l < 1000L || n < 1) {
            decimalFormat.applyPattern("#,####");
        } else if (l < 1000000L || n < 2) {
            d /= 1000.0;
            decimalFormat.applyPattern("#,##0.0");
        } else if (l < 1000000000L || n < 3) {
            d /= 1000000.0;
            decimalFormat.applyPattern("#,##0.0");
        } else {
            d /= 1.0E9;
            decimalFormat.applyPattern("#,##0.0");
        }
        return decimalFormat.format(d);
    }

    public static String toHTMLEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                stringBuffer.append("&#").append(Integer.toString(c)).append(";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static class StringSortAsc
    implements Comparable {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            return ((String)object).compareTo((String)object2);
        }
    }

    public static class IntegerSortDesc
    implements Comparable {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            if ((Integer)object == Integer.MAX_VALUE) {
                return -1;
            }
            if ((Integer)object2 == Integer.MAX_VALUE) {
                return 1;
            }
            return (Integer)object2 - (Integer)object;
        }
    }

    public static class IntegerSortAsc
    implements Comparable {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if ((Integer)object == Integer.MAX_VALUE) {
                return 1;
            }
            if ((Integer)object2 == Integer.MAX_VALUE) {
                return -1;
            }
            return (Integer)object - (Integer)object2;
        }
    }

    public static class LongSortDesc
    implements Comparable {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return 1;
            }
            if (object2 == null) {
                return -1;
            }
            if ((long)((Long)object).intValue() == Long.MAX_VALUE) {
                return -1;
            }
            if ((long)((Long)object2).intValue() == Long.MAX_VALUE) {
                return 1;
            }
            return (int)((Long)object2 - (Long)object);
        }
    }

    public static class LongSortAsc
    implements Comparable {
        public int compare(Object object, Object object2) {
            if (object == null && object2 == null) {
                return 0;
            }
            if (object == null) {
                return -1;
            }
            if (object2 == null) {
                return 1;
            }
            if ((long)((Long)object).intValue() == Long.MAX_VALUE) {
                return 1;
            }
            if ((long)((Long)object2).intValue() == Long.MAX_VALUE) {
                return -1;
            }
            return (int)((Long)object - (Long)object2);
        }
    }

    public static interface Comparable {
        public int compare(Object var1, Object var2);
    }
}

